/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.util;

import com.bxm.fossicker.util.FontText;
import com.bxm.fossicker.util.animate.AnimatedGifEncoder;
import com.bxm.fossicker.util.animate.GifDecoder;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import sun.awt.SunHints;

public class PictureMerge {
    public static void drawTextInImg(String filePath, String outPath, FontText text) throws Exception {
        ImageIcon imgIcon = new ImageIcon(filePath);
        Image img = imgIcon.getImage();
        File file = new File(filePath);
        BufferedImage bimage = ImageIO.read(file);
        Graphics2D g = bimage.createGraphics();
        g.setColor(PictureMerge.getColor(text.getWm_text_color()));
        g.drawImage(img, 0, 0, null);
        Font font = null;
        font = StringUtils.isEmpty((CharSequence)text.getWm_text_font()) && text.getWm_text_size() != null ? new Font(text.getWm_text_font(), 1, text.getWm_text_size()) : new Font(null, 1, 50);
        g.setFont(font);
        ((Graphics)g).drawString(text.getText(), 180, 200);
        g.dispose();
        FileOutputStream out = new FileOutputStream(outPath);
        ImageIO.write((RenderedImage)bimage, "gif", out);
        out.close();
    }

    public static Color getColor(String color) {
        if (color.charAt(0) == '#') {
            color = color.substring(1);
        }
        if (color.length() != 6) {
            return null;
        }
        try {
            int r = Integer.parseInt(color.substring(0, 2), 16);
            int g = Integer.parseInt(color.substring(2, 4), 16);
            int b = Integer.parseInt(color.substring(4), 16);
            return new Color(r, g, b);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getGifSticker(String markContent, String imgUrl, int size, int x, int y) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            byte[] b;
            ByteArrayInputStream inputStream1 = new ByteArrayInputStream(IOUtils.toByteArray((URL)new URL(imgUrl)));
            GifDecoder decoder = new GifDecoder();
            decoder.read(inputStream1);
            Font font = new Font(null, 1, size);
            int frameCount = decoder.getFrameCount();
            AnimatedGifEncoder encoder = new AnimatedGifEncoder();
            String url = "D:\\" + System.currentTimeMillis() + ".gif";
            encoder.start((OutputStream)outputStream);
            encoder.setRepeat(0);
            Graphics2D g = null;
            for (int i = 0; i < frameCount; ++i) {
                g = (Graphics2D)decoder.getFrame(i).getGraphics();
                g.setRenderingHint(SunHints.KEY_ANTIALIASING, SunHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(SunHints.KEY_TEXT_ANTIALIASING, SunHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
                g.setColor(Color.red);
                g.setFont(font);
                g.setFont(font);
                g.drawString(markContent, x, y);
                g.dispose();
                encoder.addFrame(decoder.getFrame(i));
                if (i == frameCount - 1) continue;
                encoder.setDelay(decoder.getDelay(i));
            }
            encoder.finish();
            byte[] byArray = b = outputStream.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (null != outputStream) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

