package com.bxm.fossicker.message.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 消息配置属性
 * @author liujia
 */
@ConfigurationProperties(prefix = "msg")
@Component
@Data
public class MessageProperties {

    /**
     * 当前启用的短信平台，优先使用启用的平台进行发送，如果发送失败为特定的情况（余额不足等原因），进行降级发送
     */
    private String activedSmsPlatform = "default";

    /**
     * 站外验证码开关
     */
    private Boolean publicSmsCodeSwitch;

    /**
     * ip地址每日最多发送验证码数量
     */
    private int ipAddrMaxTimes = 30;

    /**
     * 设备每日最多发送验证码短信数量
     */
    private int deviceMaxTimes = 5;

    /**
     * 手机号码每日最多发送验证码短信数量
     */
    private long phoneMaxTimes = 5L;

    /**
     * 验证码过期时间
     */
    private int validCodeExpiredSecond = 60;

    /**
     * 赛邮短信的发送开关，用来控制是否真的发送短信
     * 默认如果选择了就发送
     */
    private Boolean submailSwitch = true;


    /**
     * 赛邮.云通信 appid
     */
    private String submailAppId;

    /**
     * 赛邮.云通信 appKey
     */
    private String submailAppKey;

    /**
     * 特殊指定的手机号
     */
    private String specificMobiles;

    /**
     * 配置的短信模板
     */
    private Map<String, String> smsTemp;
}
