package com.bxm.fossicker.message.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * 消息模块的redis键值定义
 * @author liujia
 */
public class MsgRedisKey {
    private static KeyGenerator BASE = DefaultKeyGenerator.build().setModule("msg");

    /**
     * 短信验证码，60秒过期，和短信类型绑定
     */
    public static KeyGenerator STR_TEMP_SMS_CODE = BASE.copy().setGroup("cache").setKey("code");

    /**
     * ip 今日接受短信数量
     */
    public static KeyGenerator STR_IP_ADDR_MAX_SMS = BASE.copy().setGroup("cache").setKey("ipAddrTimes");

    /**
     * 设备今日接收短信数量，如果超过限额将发送失败
     */
    public static KeyGenerator STR_DEVICE_ADDR_MAX_SMS = BASE.copy().setGroup("cache").setKey("deviceTime");

    /**
     * 手机号码今日接收短信数量，如果超过限额将发送失败
     */
    public static KeyGenerator STR_MOBILE_MAX_SMS = BASE.copy().setGroup("cache").setKey("total");


    private MsgRedisKey() {
    }
}
