package com.bxm.fossicker.message.mix.notify;

import com.bxm.fossicker.message.enums.NotifyEnum;
import com.bxm.fossicker.message.param.MixPushParam;
import com.bxm.fossicker.message.vo.SmsMessage;
import com.bxm.fossicker.message.vo.WechatMpPushMessage;
import com.bxm.fossicker.vo.PushMessage;

/**
 * 通知消息构建
 *
 * @author liujia
 * @date 2020/03/27 15:40
 */
public interface INotifyBuilder {
    /**
     * 推送的业务类型
     *
     * @return 业务类型枚举，用于匹配参数中的类型
     */
    NotifyEnum type();

    /**
     * 构建app推送的消息结构体
     *
     * @param param 推送参数
     * @return 推送消息结构体
     */
    PushMessage buildPushMsg(MixPushParam param);

    /**
     * 构建短信推送的内容
     *
     * @param param 推送参数
     * @return 短信主体内容
     */
    SmsMessage buildSmsMsg(MixPushParam param);

    /**
     * 构建微信公众号的推送消息结构体
     *
     * @param param 推送参数
     */
    WechatMpPushMessage buildWechatMsg(MixPushParam param);
}
