package com.bxm.fossicker.message.mix.notify;

import com.bxm.fossicker.message.enums.NotifyEnum;
import com.bxm.fossicker.message.mix.notify.impl.DefaultNotifyBuilder;
import com.bxm.fossicker.message.param.MixPushParam;
import com.bxm.fossicker.message.vo.SmsMessage;
import com.bxm.fossicker.message.vo.WechatMpPushMessage;
import com.bxm.fossicker.vo.PushMessage;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * 通知消息构建者管理类
 *
 * @author liujia
 * @date 2020/03/27 15:55
 */
@Component
@Slf4j
public class NotifyBuilderManager {

    private Map<NotifyEnum, INotifyBuilder> notifyBuilderMap;

    private INotifyBuilder defaultBuilder = new DefaultNotifyBuilder();

    @Autowired
    public NotifyBuilderManager(List<INotifyBuilder> notifyBuilders) {
        notifyBuilderMap = Maps.newHashMap();

        notifyBuilders.forEach(item -> {
            notifyBuilderMap.put(item.type(), item);
        });
    }

    private INotifyBuilder getBuilder(NotifyEnum type) {
        INotifyBuilder builder = notifyBuilderMap.get(type);

        if (null == builder) {
            log.info("业务枚举类型未实现对应的INotifyBuilder或未添加到SpringContext", type);
            builder = defaultBuilder;
        }

        return builder;
    }

    public PushMessage buildPushMsg(MixPushParam param) {
        return getBuilder(param.getNotifyType()).buildPushMsg(param);
    }

    public SmsMessage builSmsMsg(MixPushParam param) {
        return getBuilder(param.getNotifyType()).buildSmsMsg(param);
    }

    public WechatMpPushMessage buildWechatMsg(MixPushParam param) {
        return getBuilder(param.getNotifyType()).buildWechatMsg(param);
    }
}
