package com.bxm.fossicker.message.mix.notify.impl;

import com.bxm.fossicker.common.config.BizConfigProperties;
import com.bxm.fossicker.message.enums.NotifyParamEnum;
import com.bxm.fossicker.message.mix.notify.INotifyBuilder;
import com.bxm.fossicker.message.param.MixPushParam;
import com.bxm.fossicker.message.vo.WechatMpPushMessage;
import com.bxm.fossicker.thirdpart.facade.enums.WxMpTemplateEnum;
import com.bxm.fossicker.vo.PushMessage;
import com.bxm.fossicker.vo.PushReceiveScope;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;

/**
 * 抽象的构建类，处理公共的构建过程
 */
public abstract class AbstractNotifyBuilder implements INotifyBuilder {

    static String MP_TITLE = "first";

    static String MP_REMARK = "remark";

    @Autowired
    protected BizConfigProperties bizConfigProperties;

    String getOrderNum(MixPushParam param) {
        String sourceOrderNum = param.get(NotifyParamEnum.ORDER_NUM);
        String orderNum = "**";

        int MAX_ORDER_NUM_LENGTH = 6;

        if (null != sourceOrderNum && sourceOrderNum.length() > MAX_ORDER_NUM_LENGTH) {
            orderNum += StringUtils.substring(sourceOrderNum,
                    sourceOrderNum.length() - MAX_ORDER_NUM_LENGTH,
                    sourceOrderNum.length());
        }
        return orderNum;
    }

    String getAmount(MixPushParam param) {
        Object amount = param.get(NotifyParamEnum.AMOUNT);

        if (amount == null) {
            return "0";
        }

        if (!(amount instanceof BigDecimal)) {
            return amount.toString();
        }

        return NumberUtils.format((BigDecimal) amount);
    }

    String getGold(MixPushParam param) {
        Long gold = param.get(NotifyParamEnum.GOLD);
        if (null == gold) {
            return "0";
        }
        return gold.toString();
    }

    String getLongStr(MixPushParam param, NotifyParamEnum type) {
        Long gold = param.get(type);
        if (null == gold) {
            return "0";
        }
        return gold.toString();
    }

    WechatMpPushMessage buildMpMsg(MixPushParam param, WxMpTemplateEnum type) {
        return WechatMpPushMessage.builder()
                .oid(param.getUserPushInfo().getWechatToken())
                .userId(param.getUserId())
                .wxMpTemplate(type)
                .build();
    }

    PushMessage getElePushMessage(MixPushParam param) {
        String content = "你有一笔饿了么补贴已经结算成功（订单"
                + getOrderNum(param) +
                "），再来一单吧";

        PushMessage message = PushMessage.build()
                .setTitle("外卖补贴到账通知")
                .setContent(content)
                .setPushReceiveScope(PushReceiveScope.pushSignle(param.getUserId()));

        String url = bizConfigProperties.getH5ServerHost() + "waimai.html#/?userId=${userId}&token=${token}";
        message.getPayloadInfo().setProtocol("qtj://normalWeb/normalWebDetail?url=" + url);

        return message;
    }
}
