package com.bxm.fossicker.message.mix.notify.impl;

import com.bxm.fossicker.message.enums.NotifyEnum;
import com.bxm.fossicker.message.enums.SmsTempEnum;
import com.bxm.fossicker.message.param.MixPushParam;
import com.bxm.fossicker.message.vo.SmsMessage;
import com.bxm.fossicker.message.vo.WechatMpPushMessage;
import com.bxm.fossicker.vo.PushMessage;
import com.bxm.newidea.component.tools.DateUtils;
import org.springframework.stereotype.Component;

import java.util.Date;

import static com.bxm.fossicker.thirdpart.facade.enums.WxMpTemplateEnum.ELE_PURCHASE_ORDER_SUCCESS;

/**
 * 饿了么分享订单下单成功后的推送信息
 *
 * @author liujia
 * @date 2020/03/27 16:13
 */
@Component
public class EleShareOrderSuccessNotifyBuilder extends AbstractNotifyBuilder {

    @Override
    public NotifyEnum type() {
        return NotifyEnum.ELE_SHARE_ORDER_SUCCESS;
    }

    @Override
    public PushMessage buildPushMsg(MixPushParam param) {
        return getElePushMessage(param);
    }

    @Override
    public SmsMessage buildSmsMsg(MixPushParam param) {
        return SmsMessage.builder()
                .smsTemplate(SmsTempEnum.ELE_COMMON_ORDER_SUCCESS)
                .args(new Object[]{getOrderNum(param)})
                .build();
    }

    @Override
    public WechatMpPushMessage buildWechatMsg(MixPushParam param) {
        return buildMpMsg(param, ELE_PURCHASE_ORDER_SUCCESS)
                .addValue(MP_TITLE, "恭喜您，一笔外卖补贴结算成功")
                .addVar("趣淘金")
                .addVar(DateUtils.formatDateTime(new Date()))
                .addVar("外卖补贴")
                .addVar("现金")
                .addVar(getAmount(param))
                .addValue(MP_REMARK, "饭点啦，赶快打开趣淘金APP再来一单吧");
    }

}
