package com.bxm.fossicker.message.mix.notify.impl;

import com.bxm.fossicker.message.enums.NotifyEnum;
import com.bxm.fossicker.message.enums.NotifyParamEnum;
import com.bxm.fossicker.message.param.MixPushParam;
import com.bxm.fossicker.message.vo.SmsMessage;
import com.bxm.fossicker.message.vo.WechatMpPushMessage;
import com.bxm.fossicker.thirdpart.facade.enums.WxMpTemplateEnum;
import com.bxm.fossicker.vo.PushMessage;
import com.bxm.fossicker.vo.PushReceiveScope;
import org.springframework.stereotype.Component;

/**
 * 0元抽奖中奖通知
 *
 * @author liujia
 * @date 2020/04/01 19:15
 */
@Component
public class IndianapolisDrawMsgNotifyBuilder extends AbstractNotifyBuilder {
    @Override
    public NotifyEnum type() {
        return NotifyEnum.INDIANAPOLIS_DRAW_MSG;
    }

    @Override
    public PushMessage buildPushMsg(MixPushParam param) {
        return PushMessage.build()
                .setTitle("开奖通知")
                .setContent("你参与的活动[" + param.get(NotifyParamEnum.TITLE) + "]开奖啦！快看看中奖结果吧！")
                .setPushReceiveScope(PushReceiveScope.pushSignle(param.getUserId()));
    }

    @Override
    public SmsMessage buildSmsMsg(MixPushParam param) {
        return null;
    }

    @Override
    public WechatMpPushMessage buildWechatMsg(MixPushParam param) {
        String title = param.get(NotifyParamEnum.TITLE);
        return buildMpMsg(param, WxMpTemplateEnum.INDIANAPOLIS_DRAW_MSG)
                .addValue(MP_TITLE, "中奖结果通知")
                .addVar("你有" + param.get(NotifyParamEnum.NUM) + "个兑奖码，请在APP查看")
                .addVar(param.get(NotifyParamEnum.TIME))
                .addVar(title)
                .addValue(MP_REMARK, "你参与的【" + title + "】活动开奖啦！");
    }
}
