package com.bxm.fossicker.message.mix.notify.impl;

import com.bxm.fossicker.message.enums.NotifyEnum;
import com.bxm.fossicker.message.enums.NotifyParamEnum;
import com.bxm.fossicker.message.enums.SmsTempEnum;
import com.bxm.fossicker.message.param.MixPushParam;
import com.bxm.fossicker.message.vo.SmsMessage;
import com.bxm.fossicker.message.vo.WechatMpPushMessage;
import com.bxm.fossicker.thirdpart.facade.enums.WxMpTemplateEnum;
import com.bxm.fossicker.vo.PushMessage;
import com.bxm.fossicker.vo.PushReceiveScope;
import org.springframework.stereotype.Component;

/**
 * 好友邀请成功奖励通知
 *
 * @author liujia
 */
@Component
public class InviteAwardNotifyBuilder extends AbstractNotifyBuilder {

    @Override
    public NotifyEnum type() {
        return NotifyEnum.INVITE_AWARD;
    }

    @Override
    public PushMessage buildPushMsg(MixPushParam param) {
        PushMessage message = PushMessage.build()
                .setTitle("现金入账通知")
                .setContent("你的好友为你贡献了一笔现金收益，速速提现吧")
                .setPushReceiveScope(PushReceiveScope.pushSignle(param.getUserId()));

        message.getPayloadInfo().setProtocol("qtj://mine/billingDetail");
        return null;
    }

    @Override
    public SmsMessage buildSmsMsg(MixPushParam param) {
        return SmsMessage.builder()
                .smsTemplate(SmsTempEnum.INVITE_AWARD)
                .build();
    }

    @Override
    public WechatMpPushMessage buildWechatMsg(MixPushParam param) {
        return buildMpMsg(param, WxMpTemplateEnum.INVITE_AWARD)
                .addValue(MP_TITLE, "邀请奖励到账通知")
                .addVar(getAmount(param))
                .addVar(param.get(NotifyParamEnum.TITLE))
                .addVar(param.get(NotifyParamEnum.TIME))
                .addValue(MP_REMARK, "你的好友为你贡献了一笔现金收益，速速打开app提现吧");
    }
}
