package com.bxm.fossicker.message.mix.notify.impl;

import com.bxm.fossicker.message.enums.NotifyEnum;
import com.bxm.fossicker.message.enums.NotifyParamEnum;
import com.bxm.fossicker.message.param.MixPushParam;
import com.bxm.fossicker.message.vo.SmsMessage;
import com.bxm.fossicker.message.vo.WechatMpPushMessage;
import com.bxm.fossicker.vo.PushMessage;
import com.bxm.fossicker.vo.PushReceiveScope;
import org.springframework.stereotype.Component;

/**
 * 邀请好友成功的消息通知
 */
@Component
public class InviteSuccessNotifyBuilder extends AbstractNotifyBuilder {
    @Override
    public NotifyEnum type() {
        return NotifyEnum.INVITE_SUCCESS;
    }

    @Override
    public PushMessage buildPushMsg(MixPushParam param) {
        PushMessage message = PushMessage.build();
        message.setTitle("成功邀请好友");
        message.setContent("恭喜你，又有一位好友接受你的邀请～");
        message.setPushReceiveScope(PushReceiveScope.pushSignle(param.getUserId()));
        message.getPayloadInfo().setProtocol("qtj://normalWeb/normalWebDetail?url=" + param.get(NotifyParamEnum.URL));
        return null;
    }

    @Override
    public SmsMessage buildSmsMsg(MixPushParam param) {
        return null;
    }

    @Override
    public WechatMpPushMessage buildWechatMsg(MixPushParam param) {
        return null;
    }
}
