package com.bxm.fossicker.message.mix.notify.impl;

import com.bxm.fossicker.message.enums.NotifyEnum;
import com.bxm.fossicker.message.enums.SmsTempEnum;
import com.bxm.fossicker.message.param.MixPushParam;
import com.bxm.fossicker.message.vo.SmsMessage;
import com.bxm.fossicker.message.vo.WechatMpPushMessage;
import com.bxm.fossicker.vo.PushMessage;
import com.bxm.fossicker.vo.PushReceiveScope;
import org.springframework.stereotype.Component;

/**
 * 用户自购成功后的消息通知
 */
@Component
public class SelfBuyFinishOrderNotifyBuilder extends AbstractNotifyBuilder {
    @Override
    public NotifyEnum type() {
        return NotifyEnum.SELF_BUY_FINISH_ORDER;
    }

    @Override
    public PushMessage buildPushMsg(MixPushParam param) {
        PushMessage message = PushMessage.build();
        message.setTitle("佣金入账通知");
        String content = "你有一笔自购佣金已经跟单成功（淘宝订单：" +
                getOrderNum(param) + ")," +
                "坐等结算提现吧~";

        message.setContent(content);
        message.setPushReceiveScope(PushReceiveScope.pushSignle(param.getUserId()));
        message.getPayloadInfo().setProtocol("qtj://mine/orderDetails");

        return message;
    }

    @Override
    public SmsMessage buildSmsMsg(MixPushParam param) {
        Object[] args = new Object[2];
        args[0] = "自购";
        args[1] = getOrderNum(param);

        return SmsMessage.builder()
                .smsTemplate(SmsTempEnum.COMMON_ORDER_ENTRY)
                .args(args)
                .build();
    }

    @Override
    public WechatMpPushMessage buildWechatMsg(MixPushParam param) {
        return null;
    }
}
