package com.bxm.fossicker.message.mix.notify.impl;

import com.bxm.fossicker.message.enums.NotifyEnum;
import com.bxm.fossicker.message.enums.NotifyParamEnum;
import com.bxm.fossicker.message.param.MixPushParam;
import com.bxm.fossicker.message.vo.SmsMessage;
import com.bxm.fossicker.message.vo.WechatMpPushMessage;
import com.bxm.fossicker.vo.PushMessage;
import com.bxm.fossicker.vo.PushReceiveScope;
import org.springframework.stereotype.Component;

/**
 * 昨日获取金币数量的推送信息
 */
@Component
public class YesterdayGoldNotifyBuilder extends AbstractNotifyBuilder {
    @Override
    public NotifyEnum type() {
        return NotifyEnum.YESTERDAY_GOLD_THAN_5000;
    }

    @Override
    public PushMessage buildPushMsg(MixPushParam param) {
        PushMessage message = PushMessage.build();
        message.setTitle("昨日金币汇报");
        String content = "恭喜，您昨日总共获得" + getGold(param) +
                "金币，其中好友贡献" + getLongStr(param, NotifyParamEnum.FRIEND_GOLD) +
                "金币，再接再厉哦";
        message.setContent(content);
        message.setPushReceiveScope(PushReceiveScope.pushSignle(param.getUserId()));
        message.getPayloadInfo().setProtocol("qtj://mine/goldDetails");

        return message;
    }

    @Override
    public SmsMessage buildSmsMsg(MixPushParam param) {
        return null;
    }

    @Override
    public WechatMpPushMessage buildWechatMsg(MixPushParam param) {
        return null;
    }
}
