package com.bxm.fossicker.message.mix.notify.impl;

import com.bxm.fossicker.message.enums.NotifyEnum;
import com.bxm.fossicker.message.enums.NotifyParamEnum;
import com.bxm.fossicker.message.enums.SmsTempEnum;
import com.bxm.fossicker.message.param.MixPushParam;
import com.bxm.fossicker.message.vo.SmsMessage;
import com.bxm.fossicker.message.vo.WechatMpPushMessage;
import com.bxm.fossicker.vo.PushMessage;
import com.bxm.fossicker.vo.PushReceiveScope;
import org.springframework.stereotype.Component;

import static com.bxm.fossicker.thirdpart.facade.enums.WxMpTemplateEnum.ZERO_COMMODITY_ORDER_SUCCESS;

/**
 * 0元购订单生效后的相关通知
 */
@Component
public class ZeroCommodityOrderSuccessNotifyBuilder extends AbstractNotifyBuilder {

    @Override
    public NotifyEnum type() {
        return NotifyEnum.ZERO_COMMODITY_ORDER_SUCCESS;
    }

    @Override
    public PushMessage buildPushMsg(MixPushParam param) {
        String content = "你有一笔0元购订单已生效（订单" + getOrderNum(param) +
                "），坐等结算提现吧";

        PushMessage message = PushMessage.build()
                .setTitle("0元购订单已生效")
                .setContent(content)
                .setPushReceiveScope(PushReceiveScope.pushSignle(param.getUserId()));

        String url = bizConfigProperties + "/index.html#/freebuy?userId=${userId}&token=${token}&tabIndex=2";
        message.getPayloadInfo().setProtocol("qtj://normalWeb/normalWebDetail?url=" + url);

        return message;
    }

    @Override
    public SmsMessage buildSmsMsg(MixPushParam param) {
        Object[] args = {getOrderNum(param), getAmount(param)};

        return SmsMessage.builder()
                .smsTemplate(SmsTempEnum.ZERO_COMMODITY_ORDER_SUCCESS)
                .args(args)
                .build();
    }

    @Override
    public WechatMpPushMessage buildWechatMsg(MixPushParam param) {
        return buildMpMsg(param, ZERO_COMMODITY_ORDER_SUCCESS)
                .addValue(MP_TITLE, "0元购订单已生效")
                .addVar(param.get(NotifyParamEnum.TIME))
                .addVar(param.get(NotifyParamEnum.TITLE))
                .addVar(getOrderNum(param))
                .addValue(MP_REMARK, "你有一笔0元购订单已生效，返佣" + getAmount(param) + "元，打开app查看");
    }
}
