package com.bxm.fossicker.message.mix.notify.impl;

import com.bxm.fossicker.message.enums.NotifyEnum;
import com.bxm.fossicker.message.enums.NotifyParamEnum;
import com.bxm.fossicker.message.enums.SmsTempEnum;
import com.bxm.fossicker.message.param.MixPushParam;
import com.bxm.fossicker.message.vo.SmsMessage;
import com.bxm.fossicker.message.vo.WechatMpPushMessage;
import com.bxm.fossicker.vo.PushMessage;
import com.bxm.fossicker.vo.PushReceiveScope;
import org.springframework.stereotype.Component;

import static com.bxm.fossicker.thirdpart.facade.enums.WxMpTemplateEnum.ZERO_COMMODITY_ORDER_SYNC;

/**
 * 0元购订单同步完成后的相关通知
 */
@Component
public class ZeroCommodityOrderSyncNotifyBuilder extends AbstractNotifyBuilder {

    @Override
    public NotifyEnum type() {
        return NotifyEnum.ZERO_COMMODITY_ORDER_SYNC;
    }

    @Override
    public PushMessage buildPushMsg(MixPushParam param) {
        String content = "你有一笔0元购订单已跟单成功（订单" + getOrderNum(param) +
                "），赶快邀请好友领全额返佣吧～";

        PushMessage message = PushMessage.build()
                .setTitle("0元购订单跟单成功")
                .setContent(content)
                .setPushReceiveScope(PushReceiveScope.pushSignle(param.getUserId()));

        String url = bizConfigProperties + "/index.html#/freebuy?userId=${userId}&token=${token}&tabIndex=2";
        message.getPayloadInfo().setProtocol("qtj://normalWeb/normalWebDetail?url=" + url);

        return message;
    }

    @Override
    public SmsMessage buildSmsMsg(MixPushParam param) {
        Object[] args = {getOrderNum(param)};

        return SmsMessage.builder()
                .smsTemplate(SmsTempEnum.ZERO_COMMODITY_ORDER_SYNC)
                .args(args)
                .build();
    }

    @Override
    public WechatMpPushMessage buildWechatMsg(MixPushParam param) {
        return buildMpMsg(param, ZERO_COMMODITY_ORDER_SYNC)
                .addValue(MP_TITLE, "0元购订单跟单成功")
                .addVar(param.get(NotifyParamEnum.TIME))
                .addVar(param.get(NotifyParamEnum.TITLE))
                .addVar(getOrderNum(param))
                .addValue(MP_REMARK, "你有一笔0元购订单已跟单成功，赶快邀请好友领全额返佣吧～");
    }
}
