package com.bxm.fossicker.message.mix.strategy;

import com.bxm.fossicker.message.enums.PushStrategyEnum;
import com.bxm.fossicker.message.param.MixPushParam;
import com.bxm.newidea.component.vo.Message;

/**
 * 推送策略接口
 *
 * @author liujia
 * @date 2020/03/27 15:44
 */
public interface IPushStrategy {
    /**
     * 支持的推送策略
     *
     * @return 推送策略枚举
     */
    PushStrategyEnum type();

    /**
     * 执行推送
     *
     * @param param 推送参数
     * @return 推送结果
     */
    Message push(MixPushParam param);
}
