package com.bxm.fossicker.message.mix.strategy.impl;

import com.bxm.fossicker.message.entity.UserDeviceBean;
import com.bxm.fossicker.message.enums.PushStrategyEnum;
import com.bxm.fossicker.message.mix.notify.NotifyBuilderManager;
import com.bxm.fossicker.message.mix.strategy.IPushStrategy;
import com.bxm.fossicker.message.param.MixPushParam;
import com.bxm.fossicker.message.push.PushMessageDispatcher;
import com.bxm.fossicker.message.vo.UserPushInfo;
import com.bxm.fossicker.vo.PushMessage;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 趣淘金APP推送
 *
 * @author liujia
 * @date 2020/03/27 15:52
 */
@Component
public class AppPushStrategy implements IPushStrategy {

    private final NotifyBuilderManager notifyBuilderManager;

    private final PushMessageDispatcher pushMessageDispatcher;

    @Autowired
    public AppPushStrategy(NotifyBuilderManager notifyBuilderManager,
                           PushMessageDispatcher pushMessageDispatcher) {
        this.notifyBuilderManager = notifyBuilderManager;
        this.pushMessageDispatcher = pushMessageDispatcher;
    }

    @Override
    public PushStrategyEnum type() {
        return PushStrategyEnum.APP;
    }

    @Override
    public Message push(MixPushParam param) {
        UserPushInfo userPushInfo = param.getUserPushInfo();
        if (null == userPushInfo.getEnableNotify() || !userPushInfo.getEnableNotify()) {
            return Message.build(false, "用户未开启通知");
        }

        if (StringUtils.isBlank(userPushInfo.getPushToken()) || StringUtils.isBlank(userPushInfo.getPushPlatform())) {
            return Message.build(false, "推送token不存在，无法进行app推送");
        }

        PushMessage pushMessage = notifyBuilderManager.buildPushMsg(param);
        if (null == pushMessage) {
            return Message.build(false);
        }
        return pushMessageDispatcher.singlePush(pushMessage, convert(userPushInfo));
    }

    private UserDeviceBean convert(UserPushInfo userPushInfo) {
        UserDeviceBean deviceBean = new UserDeviceBean();
        deviceBean.setPhoneModel(userPushInfo.getPhoneModel());
        deviceBean.setPlatform(userPushInfo.getPushPlatform());
        deviceBean.setPushToken(userPushInfo.getPushToken());
        deviceBean.setUserId(userPushInfo.getUserId());

        return deviceBean;
    }
}
