package com.bxm.fossicker.message.mix.strategy.impl;

import com.bxm.fossicker.message.enums.PushStrategyEnum;
import com.bxm.fossicker.message.mix.notify.NotifyBuilderManager;
import com.bxm.fossicker.message.mix.strategy.IPushStrategy;
import com.bxm.fossicker.message.param.MixPushParam;
import com.bxm.fossicker.message.sms.SmsSendService;
import com.bxm.fossicker.message.vo.SmsMessage;
import com.bxm.fossicker.message.vo.UserPushInfo;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 短信推送策略
 *
 * @author liujia
 * @date 2020/03/27 16:58
 */
@Component
public class SmsPushStrategy implements IPushStrategy {

    private final NotifyBuilderManager notifyBuilderManager;

    private final SmsSendService smsSendService;

    @Autowired
    public SmsPushStrategy(NotifyBuilderManager notifyBuilderManager,
                           SmsSendService smsSendService) {
        this.notifyBuilderManager = notifyBuilderManager;
        this.smsSendService = smsSendService;
    }

    @Override
    public PushStrategyEnum type() {
        return PushStrategyEnum.SMS;
    }

    @Override
    public Message push(MixPushParam param) {
        UserPushInfo userPushInfo = param.getUserPushInfo();
        if (StringUtils.isBlank(userPushInfo.getPhoneNo())) {
            return Message.build(false, "手机号码不存在");
        }

        SmsMessage smsMsg = notifyBuilderManager.builSmsMsg(param);

        if (smsMsg == null) {
            return Message.build(false);
        }

        return smsSendService.sendVariableSms(userPushInfo.getPhoneNo(),
                smsMsg.getSmsTemplate(),
                smsMsg.getArgs());
    }
}
