package com.bxm.fossicker.message.mix.strategy.impl;

import com.bxm.fossicker.message.enums.PushStrategyEnum;
import com.bxm.fossicker.message.mix.notify.NotifyBuilderManager;
import com.bxm.fossicker.message.mix.strategy.IPushStrategy;
import com.bxm.fossicker.message.param.MixPushParam;
import com.bxm.fossicker.message.vo.UserPushInfo;
import com.bxm.fossicker.message.vo.WechatMpPushMessage;
import com.bxm.fossicker.thirdpart.facade.service.WxMpMessageFacadeService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 微信公众号推送
 *
 * @author liujia
 * @date 2020/03/27 17:23
 */
@Component
@Slf4j
public class WechatPushStrategy implements IPushStrategy {

    private final NotifyBuilderManager notifyBuilderManager;

    private final WxMpMessageFacadeService wxMpMessageFacadeService;

    @Autowired
    public WechatPushStrategy(NotifyBuilderManager notifyBuilderManager,
                              WxMpMessageFacadeService wxMpMessageFacadeService) {
        this.notifyBuilderManager = notifyBuilderManager;
        this.wxMpMessageFacadeService = wxMpMessageFacadeService;
    }

    @Override
    public PushStrategyEnum type() {
        return PushStrategyEnum.WECHAT;
    }

    @Override
    public Message push(MixPushParam param) {
        UserPushInfo userPushInfo = param.getUserPushInfo();
        if (StringUtils.isBlank(userPushInfo.getWechatToken())) {
            log.info("发送微信公众号消息，但是用户并未关注公众号", param);
            return Message.build(false);
        }

        WechatMpPushMessage message = notifyBuilderManager.buildWechatMsg(param);

        if (message == null) {
            return Message.build(false);
        }

        return wxMpMessageFacadeService.singlePush(message);
    }
}
