package com.bxm.fossicker.message.push.platform;

import com.bxm.fossicker.enums.PlatformTypeEnum;
import com.bxm.fossicker.message.entity.UserDeviceBean;
import com.bxm.fossicker.vo.PushMessage;
import com.bxm.newidea.component.vo.Message;

import java.util.List;

/**
 * 消息推送平台接口
 */
public interface IPushPlatform {

    /**
     * 执行消息推送
     *
     * @param message    推送的消息实体
     * @param userDevice 用户设备信息
     */
    void push(PushMessage message, List<UserDeviceBean> userDevice);

    /**
     * 单个用户推送
     *
     * @param message    推送消息
     * @param userDevice 用户设备信息
     * @return 推送结果
     */
    Message singlePush(PushMessage message, UserDeviceBean userDevice);

    /**
     * 推送平台类型
     *
     * @return 平台枚举
     */
    PlatformTypeEnum getType();
}
