package com.bxm.fossicker.message.push.platform.impl;

import com.bxm.fossicker.enums.PlatformTypeEnum;
import com.bxm.fossicker.message.config.AppPushProperties;
import com.bxm.fossicker.message.entity.UserDeviceBean;
import com.bxm.fossicker.vo.PushMessage;
import com.google.common.collect.ImmutableList;
import com.huawei.push.javasdk.exception.HuaweiMesssagingException;
import com.huawei.push.javasdk.message.*;
import com.huawei.push.javasdk.messaging.*;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 华为推送平台
 *
 * @author liujia
 */
@Component
@RefreshScope
public class HuaweiPushPlatform extends AbstractPushPlatform implements ApplicationRunner {
    @Resource
    private AppPushProperties appPushProperties;

    private HuaweiApp app;

    private static final int BATCH_NUM = 50;

    private static final int SUCCESS_CODE = 80000000;

    private com.bxm.newidea.component.vo.Message execPush(PushMessage message, List<String> tokens, List<UserDeviceBean> spiltUserList) {

        Notification notification = new Notification(message.getTitle(), message.getContent());

        ClickAction.Builder clickActionBuilder = ClickAction.builder()
                .setType(1);

        if (message.getActionType() != null) {
            String intent = "intent://" + appPushProperties.getAppPkgName() + "/push?message=" + message.getPayloadInfo().toJsonString() +
                    "#Intent;scheme=route;launchFlags=0x20000;end";
            clickActionBuilder.setIntent(intent);
        }

        AndroidNotification androidNotification = AndroidNotification.builder()
                .setTitle(message.getTitle())
                .setBody(message.getContent())
                .setClickAction(clickActionBuilder.build())
                .build();

        AndroidConfig androidConfig = AndroidConfig.builder()
                .setNotification(androidNotification)
                .setBiTag("Trump")
                .build();

        Message huaweiMsg = Message.builder()
                .setNotification(notification)
                .setAndroidConfig(androidConfig)
                .addAllToken(tokens)
                .build();

        try {
            SendResponse responce = HuaweiMessaging.getInstance(app).send(huaweiMsg, false);
            if (SUCCESS_CODE == responce.getCode()) {
                callback(message, spiltUserList, SUCCESS);
                return com.bxm.newidea.component.vo.Message.build(true);
            } else {
                callback(message, spiltUserList, FAILED);
                logger.error("华为推送失败，失败原因：{}", responce.getMsg());
            }
        } catch (HuaweiMesssagingException e) {
            callback(message, spiltUserList, FAILED);
            logger.error("推送异常,消息内容：{},推送目标：{}", message, spiltUserList);
            logger.error(e.getMessage(), e);
        }
        return com.bxm.newidea.component.vo.Message.build(false);
    }

    @Override
    public com.bxm.newidea.component.vo.Message singlePush(PushMessage message, UserDeviceBean userDevice) {
        return execPush(message, ImmutableList.of(userDevice.getPushToken()), ImmutableList.of(userDevice));
    }

    @Override
    void groupPush(PushMessage message, List<UserDeviceBean> userDeviceList) {
        List<String> tokens = userDeviceList.stream().map(UserDeviceBean::getPushToken).collect(Collectors.toList());

        List<String> subTokens;
        List<UserDeviceBean> subUsers;

        //每50条进行一次推送
        int partNum = tokens.size() / BATCH_NUM + (tokens.size() % BATCH_NUM > 0 ? 1 : 0);

        for (int i = 0; i < partNum; i++) {
            int start = i * BATCH_NUM;
            int end = i * BATCH_NUM + BATCH_NUM;

            if (end >= tokens.size()) {
                end = tokens.size();
            }

            subTokens = tokens.subList(start, end);
            subUsers = userDeviceList.subList(start, end);

            execPush(message, subTokens, subUsers);
        }
    }

    @Override
    public PlatformTypeEnum getType() {
        return PlatformTypeEnum.HUAWEI;
    }

    @Override
    public void run(ApplicationArguments args) {
        if (app == null) {
            HuaweiCredential credential = HuaweiCredential.builder()
                    .setAppId(appPushProperties.getHuaweiAppId())
                    .setAppSecret(appPushProperties.getHuaweiClientSecret())
                    .build();

            HuaweiOption option = HuaweiOption.builder()
                    .setCredential(credential)
                    .build();

            app = HuaweiApp.initializeApp(option);
            logger.debug("初始化华为App");
        }
        logger.debug("{} runner", this.getClass());
    }
}
