package com.bxm.fossicker.message.push.platform.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.enums.PlatformTypeEnum;
import com.bxm.fossicker.enums.PushFoldTypeEnum;
import com.bxm.fossicker.enums.TemplateTypeEnum;
import com.bxm.fossicker.message.config.AppPushProperties;
import com.bxm.fossicker.message.entity.UserDeviceBean;
import com.bxm.fossicker.vo.PushMessage;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.xiaomi.xmpush.server.*;
import org.json.simple.parser.ParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;

@Component
@RefreshScope
public class MiuiPushPlatform extends AbstractPushPlatform {

    private final AppPushProperties appPushProperties;

    @Autowired
    public MiuiPushPlatform(AppPushProperties appPushProperties) {
        this.appPushProperties = appPushProperties;
    }

    @Override
    public com.bxm.newidea.component.vo.Message singlePush(PushMessage pushMessage, UserDeviceBean userDevice) {
        return execPush(pushMessage, ImmutableList.of(userDevice));
    }

    private com.bxm.newidea.component.vo.Message execPush(PushMessage pushMessage, List<UserDeviceBean> userDeviceList) {
        Constants.useOfficial();

        Sender sender = new Sender(appPushProperties.getMiuiAppSecret());

        String title = pushMessage.getTitle();
        if (title.length() > 50) {
            title = title.substring(0, 47) + "...";
        }

        String description = pushMessage.getContent();
        if (description.length() > 128) {
            description = description.substring(0, 128);
        }
        pushMessage.getPayloadInfo().getExtend().put("notifyImageUrl", pushMessage.getNotifyImageUrl());
        pushMessage.getPayloadInfo().getExtend().put("notifyText", pushMessage.getNotifyText());

        Message.Builder messageBuilder = new Message.Builder()
                .title(title)
                .description(description)
                .timeToLive(pushMessage.getPeriodTime() * 3600000)
                .payload(JSONObject.toJSONString(pushMessage.getPayloadInfo()))
                .restrictedPackageName(appPushProperties.getAppPkgName());

        if (pushMessage.getActionType() != null) {
            String encodeMsg = "";
            try {
                encodeMsg = URLEncoder.encode(pushMessage.getPayloadInfo().toJsonString(), "UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            String intent = "intent:#Intent;component=" + appPushProperties.getAppPkgName() + "/.ui.push.PushRouteActivity;S.message=" + encodeMsg +
                    ";end";
            logger.debug("推送报文:{}", intent);
            //messageBuilder.extra(Constants.EXTRA_PARAM_NOTIFY_EFFECT, Constants.NOTIFY_LAUNCHER_ACTIVITY);
            messageBuilder.extra(Constants.EXTRA_PARAM_INTENT_URI, intent);
        }

        //据安卓开发[鲍振东]所言，小米目前支持不了通知，故改为透传
        if (TemplateTypeEnum.NOTIFCTION.equals(pushMessage.getType())) {
            messageBuilder.passThrough(0);
        } else {
            messageBuilder.passThrough(1);
        }

        if (pushMessage.isMute()) {
            messageBuilder.notifyType(0);
        } else if (pushMessage.isShock()) {
            messageBuilder.notifyType(1 | 2);
        } else {
            messageBuilder.notifyType(1);
        }

        if (PushFoldTypeEnum.IMAGE.equals(pushMessage.getPushFoldType())) {
            File file = new File(pushMessage.getNotifyImageUrl());
            Media media = new Media(this.appPushProperties.getMiuiAppSecret());
            String picUrl = null;
            try {
                Result result = media.upload(file, false, true);
                logger.debug("小米上传推送文件返回结果：[{}], 返回的数据：[{}]", result.getErrorCode(), result.getData().toJSONString());
                picUrl = URLDecoder.decode(result.getData(Constants.JSON_MEDIA_PICTURE_URL), "UTF8");
            } catch (IOException e) {
                logger.error("小米推送图文消息上传大图错误: 图片地址：[{}]", pushMessage.getNotifyImageUrl());
            }

            messageBuilder.extra(new Message.NotificationStyleBuilder().bigPictureStyle()
                    .bigPicUri(picUrl).build());
        }

        if (PushFoldTypeEnum.TEXT.equals(pushMessage.getPushFoldType())) {
            messageBuilder.extra(new Message.NotificationStyleBuilder().bigTextStyle().build());
        }

        try {
            List<String> regIdList = Lists.newArrayList();
            for (UserDeviceBean userDevice : userDeviceList) {
                regIdList.add(userDevice.getPushToken());
            }
            Result result = sender.send(messageBuilder.build(), regIdList, 3);

            String parseResult = parseResult(result);
            if (SUCCESS.equals(parseResult)) {
                callback(pushMessage, userDeviceList, parseResult);
                return com.bxm.newidea.component.vo.Message.build(true);
            } else {
                logger.error("推送失败，重新推送。消息:[{}],失败原因：[{}]", pushMessage, parseResult);
                callback(pushMessage, userDeviceList, FAILED);
            }
        } catch (IOException | ParseException e) {
            logger.error(e.getMessage(), e);
            callback(pushMessage, userDeviceList, FAILED);
        }

        return com.bxm.newidea.component.vo.Message.build(false);
    }

    @Override
    void groupPush(PushMessage pushMessage, List<UserDeviceBean> userDeviceList) {
        execPush(pushMessage, userDeviceList);
    }

    private String parseResult(Result result) {
        if (result.getErrorCode().getValue() == 0) {
            return SUCCESS;
        } else {
            return result.getReason();
        }
    }

    @Override
    public PlatformTypeEnum getType() {
        return PlatformTypeEnum.MIUI;
    }
}
