package com.bxm.fossicker.message.push.receive;

import com.bxm.fossicker.enums.PlatformTypeEnum;
import com.bxm.fossicker.message.domain.UserDeviceMapper;
import com.bxm.fossicker.message.entity.UserDeviceBean;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * 接收用户列表迭代器
 */
public interface IReceiveUserIterator extends Iterator<Map<PlatformTypeEnum, List<UserDeviceBean>>> {

    /**
     * 构建用户信息获取迭代器
     * @param paramMap 构建参数
     * @return 迭代器对象
     */
    IReceiveUserIterator build(Map<String, Object> paramMap);

    /**
     * 迭代器为原型模式，需要手动注入需要的spring bean
     * @param userDeviceMapper 用户信息查询Mapper
     * @return 当前迭代器
     */
    IReceiveUserIterator setUserDeviceMapper(UserDeviceMapper userDeviceMapper);
}
