package com.bxm.fossicker.message.push.receive;

import com.bxm.fossicker.enums.PushReceiverRuleEnum;
import com.bxm.fossicker.message.domain.UserDeviceMapper;
import com.bxm.fossicker.message.push.receive.impl.AllReceiveUserIterator;
import com.bxm.fossicker.message.push.receive.impl.DefaultUserReceiveUserIterator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 构建用户获取迭代器对象
 */
@Component
public class ReceiveUserFactory {

    private final UserDeviceMapper userDeviceMapper;

    private ApplicationContext applicationContext;

    private Map<PushReceiverRuleEnum, IReceiveUserIterator> iteratorMap;

    @Autowired
    public ReceiveUserFactory(UserDeviceMapper userDeviceMapper) {
        this.userDeviceMapper = userDeviceMapper;
    }

    public IReceiveUserIterator get(PushReceiverRuleEnum rule, Map<String, Object> paramMap) {
        IReceiveUserIterator iterator;
        switch (rule) {
            case ALL:
                iterator = new AllReceiveUserIterator();
                break;
            default:
                iterator = new DefaultUserReceiveUserIterator();
        }
        return iterator.build(paramMap).setUserDeviceMapper(userDeviceMapper);
    }
}
