package com.bxm.fossicker.message.push.receive.impl;

import com.bxm.fossicker.message.entity.UserDeviceBean;
import com.bxm.fossicker.message.push.receive.IReceiveUserIterator;

import java.util.List;
import java.util.Map;

/**
 * 获取全部的用户信息的迭代器
 * @author liujia
 */
public class AllReceiveUserIterator extends AbstractReceiveUserIterator {

    @Override
    int getTotal() {
        return userDeviceMapper.getAllUser();
    }

    @Override
    List<UserDeviceBean> queryByPage(int pageNum) {
        return userDeviceMapper.getAllUserByPage(pageNum * pageSize, pageSize);
    }

    @Override
    public IReceiveUserIterator build(Map<String, Object> paramMap) {
        AllReceiveUserIterator iterator = new AllReceiveUserIterator();
        iterator.paramMap = paramMap;
        return iterator;
    }
}
