package com.bxm.fossicker.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.message.facade.PushFacadeService;
import com.bxm.fossicker.message.mix.MixPushDispatcher;
import com.bxm.fossicker.message.param.MixPushParam;
import com.bxm.fossicker.message.push.PushMessageDispatcher;
import com.bxm.fossicker.vo.PushMessage;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class PushFacadeServiceImpl implements PushFacadeService {

    private final PushMessageDispatcher dispatcher;

    private final MixPushDispatcher mixPushDispatcher;

    @Autowired
    public PushFacadeServiceImpl(PushMessageDispatcher dispatcher,
                                 MixPushDispatcher mixPushDispatcher) {
        this.dispatcher = dispatcher;
        this.mixPushDispatcher = mixPushDispatcher;
    }

    @Override
    public Message push(PushMessage message) {

        if (log.isDebugEnabled()) {
            log.debug("推送消息：{}", JSON.toJSONString(message));
        }

        if (!message.valid()) {
            return Message.build(false, "消息不完整");
        }

        dispatcher.push(message);
        return Message.build();
    }

    @Override
    public void push(MixPushParam param) {
        if (log.isDebugEnabled()) {
            log.debug("混合推荐参数：{}", JSON.toJSONString(param));
        }

        if (null == param || !param.valid()) {
            log.error("推送参数不完整，请求参数：{}", JSON.toJSONString(param));
            return;
        }

        mixPushDispatcher.push(param);
    }
}
