package com.bxm.fossicker.message.service.impl;

import com.bxm.fossicker.message.enums.SmsTempEnum;
import com.bxm.fossicker.message.facade.SmsFacadeService;
import com.bxm.fossicker.message.sms.SmsSendService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.vo.Message;
import com.google.common.base.Preconditions;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import static com.bxm.fossicker.message.constant.MsgRedisKey.STR_TEMP_SMS_CODE;

/**
 * 短信第三方调用接口实现
 *
 * @author liujia
 */
@Service
@Slf4j
public class SmsFacadeServiceImpl implements SmsFacadeService {

    private final RedisStringAdapter redisStringAdapter;

    private final SmsSendService smsSendService;

    @Autowired
    public SmsFacadeServiceImpl(RedisStringAdapter redisStringAdapter,
                                SmsSendService smsSendService) {
        this.redisStringAdapter = redisStringAdapter;
        this.smsSendService = smsSendService;
    }

    @Override
    public String getCode(String phone, SmsTempEnum smsType) {
        Preconditions.checkArgument(smsType != null);

        KeyGenerator key = STR_TEMP_SMS_CODE.copy().appendKey(phone).appendKey(smsType.name());
        return redisStringAdapter.get(key, String.class);
    }

    @Override
    public void rmCode(String phone, SmsTempEnum smsType) {
        Preconditions.checkArgument(smsType != null);

        KeyGenerator key = STR_TEMP_SMS_CODE.copy().appendKey(phone).appendKey(smsType.name());
        redisStringAdapter.remove(key);

    }

    @Override
    public Message sendSmsCode(String phone, SmsTempEnum smsType) {
        return smsSendService.sendSmsCode(phone, smsType);
    }

    @Override
    public Message sendSms(String phone, SmsTempEnum smsType, Object... args) {
        return smsSendService.sendVariableSms(phone, smsType, args);
    }

}
