package com.bxm.fossicker.message.sms;

import com.bxm.fossicker.message.enums.SmsTempEnum;
import com.bxm.fossicker.message.param.SendSmsCodeParam;
import com.bxm.newidea.component.vo.Message;

import java.util.List;

/**
 * 短信发送服务接口
 *
 * @author liujia
 */
public interface SmsSendService {

    /**
     * 给用户发送指定的短信（验证码）
     *
     * @param phone   接收短信号码
     * @param smsTemp 短信类型
     *                仅支持smsTemp.smsType = SmsTypeEnum.SMS_CODE
     * @return 发送结果
     */
    @Deprecated
    Message sendSmsCode(String phone, SmsTempEnum smsTemp);

    /**
     * 给用户发送指定的短信（验证码）
     *
     * @return 发送结果
     */
    Message sendSmsCode(SendSmsCodeParam param);

    /**
     * 给用户发送指定的短信
     *
     * @param phone   接收短信号码
     * @param smsTemp 短信类型
     * @param args    模板对应的参数
     *                仅支持smsTemp.smsType = SmsTypeEnum.ARGUMENT_FROM_CONFIG || smsTemp.smsType = SmsTypeEnum.ARGUMENT
     * @return 发送结果
     * @author Gonzo
     */
    Message sendVariableSms(String phone, SmsTempEnum smsTemp, Object... args);

    /**
     * 批量进行短信发送，主要给运营后台调用
     *
     * @param phoneList 手机号码列表
     * @param content   短信内容(自定义内容，支持运营短信)
     * @return 发送结果
     */
    Message multiSend(List<String> phoneList, String content);
}
