package com.bxm.fossicker.message.sms.impl;

import com.bxm.fossicker.message.entity.SmsBean;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class DefaultSmsPlatform extends AbstractSmsPlatform {
    @Override
    public String name() {
        return "default";
    }

    @Override
    void doSendSmsCode(String phone, String content) {
        SmsBean entity = new SmsBean();
        entity.setContent(content);
        entity.setReceiveNo(phone);
        entity.setStatus((byte) 1);

        saveSendRecord(entity);
    }

    @Override
    void doSendVariableSms(String phone, String content, Object... args) {
        log.info("执行默认的短信处理：{}", content);

        SmsBean entity = new SmsBean();
        entity.setContent(content);
        entity.setReceiveNo(phone);
        entity.setStatus((byte) 1);

        saveSendRecord(entity);
    }
}
