package com.bxm.fossicker.message.sms.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.fossicker.message.entity.SmsBean;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 赛邮.云通信发送短信
 * api地址：https://www.mysubmail.com/chs/documents/developer/yQZyA
 *
 * @author liujia
 * 253用来发送营销短信
 * submail发送验证码
 */
@Component
@Slf4j
public class SubmailSmsPlatform extends AbstractSmsPlatform {

    private static final String REQUEST_URL = "https://api.mysubmail.com/message/send.json";

    private final HttpClientService httpClientService;

    @Autowired
    public SubmailSmsPlatform(HttpClientService httpClientService) {
        this.httpClientService = httpClientService;
    }

    @Override
    public String name() {
        return "submail";
    }

    @Override
    protected void doSendSmsCode(String phone, String content) {
        Response response;

        // 是否开启短信发送
        if (Objects.equals(messageProperties.getSubmailSwitch(), Boolean.TRUE)) {
            response = send(phone, content);

        } else {
            response = new Response();
            response.setStatus("success");
            response.setMsg("短信开关关闭");
        }

        if (null != response) {
            SmsBean entity = new SmsBean();
            entity.setContent(content);
            entity.setReceiveNo(phone);
            entity.setStatus((byte) ("success".equals(response.getStatus()) ? 1 : 0));
            entity.setResult(response.getMsg());

            log.info("submail doSendSmsCode:[{}]", entity);

            saveSendRecord(entity);
        }
    }

    @Override
    protected void doSendVariableSms(String phone, String content, Object... args) {
        // submail 暂时不支持营销类的变量短信发送
        log.info("submail不支持变量短信发送，短信内容：{}", content);
    }

    private Response send(String phone, String content) {
        JSONObject json = new JSONObject();
        json.put("appid", messageProperties.getSubmailAppId());
        json.put("signature", messageProperties.getSubmailAppKey());
        json.put("to", phone);
        json.put("content", content);
        json.put("sign_type", "normal");

        try {
            String responseJson = httpClientService.doPostJson(REQUEST_URL, json.toJSONString());
            log.debug("phone:[{}],content:[{}],response:[{}]", phone, content, responseJson);

            return JSONObject.parseObject(responseJson, Response.class);
        } catch (Exception e) {
            log.error("submail 发送短信失败", e);
        }

        Response response = new Response();
        response.setMsg("发送失败");
        response.setStatus("failed");
        return response;
    }
}

/**
 * 第三方反馈的json格式
 */
@Data
class Response {
    /**
     * success：发送成功，error：发送失败
     */
    private String status;

    /**
     * 发送ID
     */
    private String send_id;

    /**
     * 是否免费
     */
    private String free;

    private String sms_credits;

    /**
     * 错误消息
     */
    private String msg;
}
