package com.bxm.fossicker.message.sms.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.fossicker.message.entity.SmsBean;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * @authoer Gonzo
 * @date 2019-08-26 13:54
 * api地址：https://zz.253.com/api_doc/shi-yong-chang-jing/bian-liang-duan-xin.html
 * 253用来发送营销短信
 * submail发送验证码
 */
@Slf4j
@Component
public class TwoFiveThreeSmsPlatform extends AbstractSmsPlatform {

    private String smsVariableRequestUrl = "http://smssh1.253.com/msg/variable/json";

    /**
     * 普通短消息发送
     */
    private String normalSmsSendUrl = "http://smssh1.253.com/msg/send/json";

    private String account = "M0544374";

    private String password = "k4epn0ZoP27fdc";

    /**
     * 是否返回报告
     */
    private String report = "true";

    @Autowired
    private HttpClientService httpClientService;

    @Override
    public String name() {
        return "253";
    }

    @Override
    protected void doSendSmsCode(String phone, String content) {


    }

    @Override
    protected void doSendVariableSms(String phone, String content, Object... args) {
        SmsBean entity;

        if (null == args || args.length == 0) {
            entity = sendNormalSms(phone, content);

        } else {
            StringBuilder params = new StringBuilder(phone);
            for (Object arg : args) {
                params.append(",");
                params.append(arg);
            }

            entity = doSendVariableSms(phone, content, params.toString());
        }


        if (null != entity) {
            saveSendRecord(entity);
            return;
        }

        log.warn("短信发送失败: phone:{}, content: {}, args: {}", phone, content, args);
    }

    /**
     * 发送普通短信
     *
     * @param phone   手机号
     * @param content 短信内容
     * @return
     */
    private SmsBean sendNormalSms(String phone, String content) {
        SmsSendRequest smsSingleRequest = new SmsSendRequest(account, password, content, phone, report);

        String requestJson = JSON.toJSONString(smsSingleRequest);


        try {
            String response = httpClientService.doPostJson(normalSmsSendUrl, requestJson);
            SmsSendResponse smsSingleResponse = JSON.parseObject(response, SmsSendResponse.class);

            SmsBean entity = new SmsBean();
            entity.setContent(content);
            entity.setReceiveNo(phone);
            entity.setStatus((byte) (Objects.equals("0", smsSingleResponse.getCode()) ? 1 : 0));
            entity.setResult(response);

            log.debug("253 sendNormalSms:[{}]", entity);

            return entity;

        } catch (Exception e) {
            log.error("发送253普通短信失败", e);
        }

        return null;

    }

    /**
     * 发送变量短信
     *
     * @param phone   手机号
     * @param content 带占位符的的短信模板
     * @param params  参数
     * @return
     */
    private SmsBean doSendVariableSms(String phone, String content, String params) {

        SmsVariableRequest smsVariableRequest = new SmsVariableRequest(account, password, content, params, report);

        String requestJson = JSON.toJSONString(smsVariableRequest);

        try {

            String response = httpClientService.doPostJson(smsVariableRequestUrl, requestJson);

            SmsVariableResponse smsVariableResponse = JSON.parseObject(response, SmsVariableResponse.class);
            smsVariableResponse.setResult(response);

            SmsBean entity = new SmsBean();
            entity.setContent(content + params);
            entity.setReceiveNo(phone);
            entity.setStatus((byte) (Objects.equals("0", smsVariableResponse.getCode()) ? 1 : 0));
            entity.setResult(response);

            log.debug("253 doSendVariableSms:[{}],response:[{}]", entity, response);

            return entity;
        } catch (Exception e) {
            log.error("253短信发送失败", e);
        }

        return null;
    }
}

class SmsVariableRequest {
    /**
     * 用户账号，必填
     */
    private String account;

    /**
     * 用户密码，必填
     */
    private String password;

    /**
     * 短信内容。长度不能超过536个字符，必填
     */
    private String msg;

    /**
     * 手机号码和变量参数，多组参数使用英文分号;区分，必填
     */
    private String params;

    /**
     * 定时发送短信时间。格式为yyyyMMddHHmm，值小于或等于当前时间则立即发送，默认立即发送，选填
     */
    private String sendtime;

    /**
     * 是否需要状态报告（默认false），选填
     */
    private String report;

    /**
     * 下发短信号码扩展码，纯数字，建议1-3位，选填
     */
    private String extend;

    /**
     * 该条短信在您业务系统内的ID，如订单号或者短信发送记录流水号，选填
     */
    private String uid;

    public SmsVariableRequest() {

    }

    public SmsVariableRequest(String account, String password, String msg, String params) {
        super();
        this.account = account;
        this.password = password;
        this.msg = msg;
        this.params = params;
    }

    public SmsVariableRequest(String account, String password, String msg, String params, String report) {
        super();
        this.account = account;
        this.password = password;
        this.msg = msg;
        this.params = params;
        this.report = report;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getSendtime() {
        return sendtime;
    }

    public void setSendtime(String sendtime) {
        this.sendtime = sendtime;
    }

    public String getReport() {
        return report;
    }

    public void setReport(String report) {
        this.report = report;
    }

    public String getExtend() {
        return extend;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getParams() {
        return params;
    }

    public void setParams(String params) {
        this.params = params;
    }
}

class SmsVariableResponse {
    /**
     * 响应时间
     */
    private String time;

    /**
     * 消息id
     */
    private String msgId;

    /**
     * 状态码说明（成功返回空）
     */
    private String errorMsg;

    /**
     * 失败的个数
     */
    private String failNum;

    /**
     * 成功的个数
     */
    private String successNum;

    /**
     * 状态码（详细参考提交响应状态码）
     */
    private String code;

    private String result;

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getMsgId() {
        return msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getFailNum() {
        return failNum;
    }

    public void setFailNum(String failNum) {
        this.failNum = failNum;
    }

    public String getSuccessNum() {
        return successNum;
    }

    public void setSuccessNum(String successNum) {
        this.successNum = successNum;
    }

    @Override
    public String toString() {
        return "SmsVarableResponse [time=" + time + ", msgId=" + msgId + ", errorMsg=" + errorMsg + ", failNum="
                + failNum + ", successNum=" + successNum + ", code=" + code + "]";
    }
}


class SmsSendResponse {
    /**
     * 响应时间
     */
    private String time;

    /**
     * 消息id
     */
    private String msgId;

    /**
     * 状态码说明（成功返回空）
     */
    private String errorMsg;

    /**
     * 状态码（详细参考提交响应状态码）
     */
    private String code;

    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getMsgId() {
        return msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String toString() {
        return "SmsSingleResponse [time=" + time + ", msgId=" + msgId + ", errorMsg=" + errorMsg + ", code=" + code
                + "]";
    }
}

class SmsSendRequest {
    /**
     * 用户账号，必填
     */
    private String account;

    /**
     * 用户密码，必填
     */
    private String password;

    /**
     * 短信内容。长度不能超过536个字符，必填
     */
    private String msg;

    /**
     * 机号码。多个手机号码使用英文逗号分隔，必填
     */
    private String phone;


    /**
     * 定时发送短信时间。格式为yyyyMMddHHmm，值小于或等于当前时间则立即发送，默认立即发送，选填
     */
    private String sendtime;

    /**
     * 是否需要状态报告（默认false），选填
     */
    private String report;

    /**
     * 下发短信号码扩展码，纯数字，建议1-3位，选填
     */
    private String extend;

    /**
     * 该条短信在您业务系统内的ID，如订单号或者短信发送记录流水号，选填
     */
    private String uid;

    public SmsSendRequest() {

    }

    public SmsSendRequest(String account, String password, String msg, String phone) {
        super();
        this.account = account;
        this.password = password;
        this.msg = msg;
        this.phone = phone;
    }

    public SmsSendRequest(String account, String password, String msg, String phone, String report) {
        super();
        this.account = account;
        this.password = password;
        this.msg = msg;
        this.phone = phone;
        this.report = report;
    }

    public SmsSendRequest(String account, String password, String msg, String phone, String report, String sendtime) {
        super();
        this.account = account;
        this.password = password;
        this.msg = msg;
        this.phone = phone;
        this.sendtime = sendtime;
        this.report = report;
    }

    public SmsSendRequest(String account, String password, String msg, String phone, String sendtime, String report, String uid) {
        super();
        this.account = account;
        this.password = password;
        this.msg = msg;
        this.phone = phone;
        this.sendtime = sendtime;
        this.report = report;
        this.uid = uid;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getSendtime() {
        return sendtime;
    }

    public void setSendtime(String sendtime) {
        this.sendtime = sendtime;
    }

    public String getReport() {
        return report;
    }

    public void setReport(String report) {
        this.report = report;
    }

    public String getExtend() {
        return extend;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }
}
