package com.bxm.fossicker.message.timer;

import com.bxm.fossicker.message.domain.AdminPushMessageMapper;
import com.bxm.fossicker.message.facade.PushFacadeService;
import com.bxm.fossicker.message.param.PushMessageStatusEnum;
import com.bxm.fossicker.message.param.PushMsgBuildParam;
import com.bxm.fossicker.vo.PushMessage;
import com.bxm.newidea.component.schedule.task.AbstractTaskCallback;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;


@Component
@Log4j2
public class PushMessageTask extends AbstractTaskCallback<PushMsgBuildParam> {
    @Resource
    private AdminPushMessageMapper adminPushMessageMapper;

    @Resource
    private PushFacadeService pushFacadeService;

    @Override
    protected ReturnT<String> service(PushMsgBuildParam pushMsgBuildParam) {
        Long messageId = pushMsgBuildParam.getMessageId();
        PushMessage pushMessage = pushMsgBuildParam.getPushMessage();

        int status = adminPushMessageMapper.selectByPrimaryKey(messageId);

        if (PushMessageStatusEnum.STAY_CONFIRM.getType().equals(status)) {
            log.warn("消息ID[{}]已取消推送", messageId);
            return ReturnT.FAIL;
        }
        if (PushMessageStatusEnum.BEING_SEND.getType().equals(status)) {
            log.warn("消息ID[{}]正在推送中", messageId);
            return ReturnT.FAIL;
        }
        if (PushMessageStatusEnum.HAS_BEEN_SEND.getType().equals(status)) {
            return ReturnT.FAIL;
        }

        log.debug("执行消息推送,推送消息ID:[{}],推送消息对象：[{}]", messageId, pushMessage);

        adminPushMessageMapper.updatePushMessageStatus(messageId, PushMessageStatusEnum.BEING_SEND.getType());
        pushFacadeService.push(pushMessage);

        return ReturnT.SUCCESS;
    }
}
