package com.bxm.foundation.config.advert.facade.dto;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author pf.w
 * @date 2021/7/1 13:53
 **/
@ApiModel("广告数据列表")
@Data
public class AdvertDTO {

    @ApiModelProperty("广告投放ID")
    private Long id;

    @ApiModelProperty(value = "应用标志")
    private String srcApp;

    @ApiModelProperty(value = "投放位置code 格式{srcApp}_{页面tab}_{页面位置}_{类型}")
    private String positionCode;

    @ApiModelProperty(value = "素材顺序")
    private Integer materialOrder;

    @ApiModelProperty(value = "广告标题")
    private String AdvertTitle;

    @ApiModelProperty(value = "广告副标题")
    private String AdvertSubTitle;

    /*******************************素材信息信息*******************************/

    @ApiModelProperty(value = "素材ID主键")
    private Long MaterialId;

    @ApiModelProperty(value = "素材标题")
    private String title;

    @ApiModelProperty(value = "素材副标题")
    private String subTitle;

    @ApiModelProperty(value = "素材类型,1-纯文字，2-图文，3-gif，4-icon")
    private Integer type;

    @ApiModelProperty(value = "素材内容")
    private String content;

    @ApiModelProperty(value = "显示文案")
    private String description;

    @ApiModelProperty(value = "图片高度")
    private String imgHeight;

    @ApiModelProperty(value = "图片宽度")
    private String imgWidth;

    @ApiModelProperty(value = "图片地址")
    private String imgUrl;

    @ApiModelProperty(value = "素材后续操作，-无，1-打开商品，2-跳转链接，3-跳转搜索，4-跳转联盟官方活动")
    private Integer followSelect;

    @ApiModelProperty(value = "跳转协议地址")
    private String url;

    @ApiModelProperty(value = "图标图片地址")
    private String iconUrl;

}
