package com.bxm.foundation.config.advert.service.thirdparty.callback;

import com.bxm.foundation.config.advert.entity.thirdparty.ThirdpartyAdvertClickHistoryEntity;
import com.bxm.foundation.config.advert.service.thirdparty.callback.impl.AbstractCallback;
import com.bxm.foundation.config.advert.service.thirdparty.callback.impl.DefaultCallback;
import com.google.common.collect.Maps;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 广告回调管理
 *
 * @author liujia
 * @date 2019/12/23 16:51
 */
@Component
public class AdvertCallback implements Callback, ApplicationRunner, ApplicationContextAware {

    private Map<String, Callback> callbackMap;

    private DefaultCallback defaultCallback = new DefaultCallback();

    private ApplicationContext applicationContext;

    private Callback get(ThirdpartyAdvertClickHistoryEntity click) {
        Callback callback = callbackMap.get(click.getType());
        if (callback == null) {
            return defaultCallback;
        }
        return callback;
    }

    @Override
    public void active(ThirdpartyAdvertClickHistoryEntity click) {
        get(click).active(click);
    }

    @Override
    public void login(ThirdpartyAdvertClickHistoryEntity click) {
        get(click).login(click);
    }

    @Override
    public void payment(ThirdpartyAdvertClickHistoryEntity click) {
        get(click).payment(click);
    }

    @Override
    public void nextDayLeft(ThirdpartyAdvertClickHistoryEntity click) {
        get(click).nextDayLeft(click);
    }

    @Override
    public void cruxBehaviors(ThirdpartyAdvertClickHistoryEntity click) {
        get(click).cruxBehaviors(click);
    }

    @Override
    public void run(ApplicationArguments args) {
        Map<String, AbstractCallback> beans = applicationContext.getBeansOfType(AbstractCallback.class);

        callbackMap = Maps.newHashMap();
        beans.values().forEach(callback -> callbackMap.put(callback.platform().name(), callback));
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
