package com.bxm.foundation.config.advert.service.thirdparty.callback;

import com.bxm.foundation.config.advert.entity.thirdparty.ThirdpartyAdvertClickHistoryEntity;
import com.bxm.foundation.config.advert.service.enums.ThridpartyAdvertEnum;

/**
 * 广告回调接口，当用户进行到某一个步骤时，反馈给广告平台
 * 此处设计有问题，可以重构成事件驱动
 *
 * @author liujia
 * @date 2019/12/23 16:44
 */
public interface Callback {

    /**
     * 激活时的回调
     *
     * @param click 点击参数
     */
    void active(ThirdpartyAdvertClickHistoryEntity click);

    /**
     * 登录后的回调
     *
     * @param click 点击历史信息
     */
    void login(ThirdpartyAdvertClickHistoryEntity click);

    /**
     * 用户发生付费行为
     *
     * @param click 点击历史信息
     */
    void payment(ThirdpartyAdvertClickHistoryEntity click);

    /**
     * 次日留存
     *
     * @param click 点击历史信息
     */
    default void nextDayLeft(ThirdpartyAdvertClickHistoryEntity click) {
    }

    /**
     * 关键行为
     *
     * @param click 点击历史信息
     */
    default void cruxBehaviors(ThirdpartyAdvertClickHistoryEntity click) {
    }


    /**
     * 匹配的广告平台
     *
     * @return 广告平台枚举
     */
    default ThridpartyAdvertEnum platform() {
        return null;
    }
}
