package com.bxm.foundation.config.advert.service.thirdparty.callback.impl;

import com.bxm.component.httpclient.service.OKHttpService;
import com.bxm.foundation.config.advert.entity.thirdparty.ThirdpartyAdvertClickHistoryEntity;
import com.bxm.foundation.config.advert.service.constant.ThirdpartyRedisConfig;
import com.bxm.foundation.config.advert.service.enums.CallbackEventType;
import com.bxm.foundation.config.advert.service.thirdparty.callback.Callback;
import com.bxm.foundation.config.advert.thirdparty.mapper.ThirdpartyAdvertClickHistoryMapper;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;


/**
 * 抽象的回调接口
 *
 * @author liujia
 * @date 2019/12/23 16:58
 */
@Slf4j
public abstract class AbstractCallback implements Callback {

    @Resource
    OKHttpService okHttpService;

    @Resource
    ThirdpartyAdvertClickHistoryMapper advertClickHistoryMapper;

    @Resource
    RedisHashMapAdapter redisHashMapAdapter;

    void modifyHistory(ThirdpartyAdvertClickHistoryEntity click, CallbackEventType eventType) {
        advertClickHistoryMapper.updateById(click);

        KeyGenerator key = ThirdpartyRedisConfig.ADVERT_EVENT_CALLBACK_CACHE.copy().appendKey(click.getEquipmentId());
        redisHashMapAdapter.put(key, eventType.name(), Boolean.TRUE);

        log.debug("设备[{}]完成事件[{}]触发", click.getEquipmentId(), eventType.name());
    }
}
