package com.bxm.foundation.config.advert.service.thirdparty.callback.impl;

import com.bxm.foundation.config.advert.entity.thirdparty.ThirdpartyAdvertClickHistoryEntity;
import com.bxm.foundation.config.advert.service.enums.CallbackEventType;
import com.bxm.foundation.config.advert.service.enums.ThridpartyAdvertEnum;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 快手广告点击效果回传
 *
 * @author liujia
 * @date 5/14/21 4:26 PM
 **/
@Component
@Slf4j
public class KuaishouClickCallback extends AbstractCallback {
    @Override
    public void active(ThirdpartyAdvertClickHistoryEntity click) {
        log.debug("快手active回调：{}", click);

        Map<String, String> paramMap = Maps.newHashMap();
        paramMap.put("event_type", "1");
        paramMap.put("event_time", System.currentTimeMillis() + "");

        String response = okHttpService.get(click.getCallBack(), paramMap, Maps.newHashMap());
        log.info("快手active回调,上报结果：{}", response);

        modifyHistory(click, CallbackEventType.ACTIVE);
    }

    @Override
    public void login(ThirdpartyAdvertClickHistoryEntity click) {
        log.debug("快手login回调：{}", click);

        Map<String, String> paramMap = Maps.newHashMap();
        paramMap.put("event_type", "2");
        paramMap.put("event_time", System.currentTimeMillis() + "");

        String response = okHttpService.get(click.getCallBack(), paramMap, Maps.newHashMap());
        log.info("快手login回调,上报结果：{}", response);

        modifyHistory(click, CallbackEventType.LOGIN);
    }

    @Override
    public void payment(ThirdpartyAdvertClickHistoryEntity click) {
        log.debug("快手payment回调：{}", click);

        Map<String, String> paramMap = Maps.newHashMap();
        paramMap.put("event_type", "3");
        paramMap.put("event_time", System.currentTimeMillis() + "");

        String response = okHttpService.get(click.getCallBack(), paramMap, Maps.newHashMap());
        log.info("快手payment回调,上报结果：{}", response);

        modifyHistory(click, CallbackEventType.PAYMENT);
    }

    @Override
    public void nextDayLeft(ThirdpartyAdvertClickHistoryEntity click) {
        log.info("快手次日留存回调：{}", click);

        Map<String, String> paramMap = Maps.newHashMap();
        paramMap.put("event_type", "7");
        paramMap.put("event_time", System.currentTimeMillis() + "");

        String response = okHttpService.get(click.getCallBack(), paramMap, Maps.newHashMap());
        log.info("快手次日留存回调,上报结果：{}", response);
    }


    @Override
    public ThridpartyAdvertEnum platform() {
        return ThridpartyAdvertEnum.KUAISHOU_CLICK;
    }
}
