package com.bxm.foundation.config.advert.service.thirdparty.callback.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.foundation.config.advert.entity.thirdparty.ThirdpartyAdvertClickHistoryEntity;
import com.bxm.foundation.config.advert.service.enums.CallbackEventType;
import com.bxm.foundation.config.advert.service.enums.ThridpartyAdvertEnum;
import com.bxm.newidea.component.enums.PlatformEnum;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.Map;

/**
 * 今日头条的广告点击回调
 *
 * @author liujia
 * @date 2019/12/23 17:11
 */
@Component
@Slf4j
public class TtCallback extends AbstractCallback {
    @Override
    public void active(ThirdpartyAdvertClickHistoryEntity click) {
        String callbackUrl = click.getCallBack();

        Map<String, String> paramMap = build(click);
        paramMap.put("event_type", "0");

        if (log.isDebugEnabled()) {
            log.debug("今日头条触发激活广告回调，回调参数：{}", JSON.toJSONString(paramMap));
        }

        String response = okHttpService.get(callbackUrl, paramMap, Maps.newHashMap());
        parseResponse(response);

        click.setEffectTime(new Date());
        modifyHistory(click, CallbackEventType.ACTIVE);
    }

    @Override
    public void login(ThirdpartyAdvertClickHistoryEntity click) {
        String callbackUrl = click.getCallBack();

        Map<String, String> paramMap = build(click);
        paramMap.put("event_type", "1");

        if (log.isDebugEnabled()) {
            log.debug("今日头条触发登录广告回调，回调参数：{}", JSON.toJSONString(paramMap));
        }

        String response = okHttpService.get(callbackUrl, paramMap, Maps.newHashMap());
        parseResponse(response);

        modifyHistory(click, CallbackEventType.LOGIN);
    }

    @Override
    public void payment(ThirdpartyAdvertClickHistoryEntity click) {
        String callbackUrl = click.getCallBack();

        Map<String, String> paramMap = build(click);
        paramMap.put("event_type", "2");

        if (log.isDebugEnabled()) {
            log.debug("今日头条触发支付广告回调，回调参数：{}", JSON.toJSONString(paramMap));
        }

        String response = okHttpService.get(callbackUrl, paramMap, Maps.newHashMap());
        parseResponse(response);

        modifyHistory(click, CallbackEventType.PAYMENT);
    }

    @Override
    public void cruxBehaviors(ThirdpartyAdvertClickHistoryEntity click) {
        String callbackUrl = click.getCallBack();

        //头条关键行为定义为25
        Map<String, String> paramMap = build(click);
        paramMap.put("event_type", "25");

        log.info("今日头条触发新人领8.8红包广告回调，回调参数：{}", JSON.toJSONString(paramMap));

        String response = okHttpService.get(callbackUrl, paramMap, Maps.newHashMap());

        log.info("今日头条触发新人领8.8红包广告回调结果参数response：{}", JSON.toJSONString(response));
        parseResponse(response);

        modifyHistory(click, CallbackEventType.CRUX_BEHAVIORS);
    }

    private void parseResponse(String response) {
        JSONObject json = JSONObject.parseObject(response);
        if (null != json) {
            log.debug("今日头条回调，回调结果:{}", json.toJSONString());

            if (0 != json.getIntValue("ret")) {
                log.error("今日头条回调失败，回调结果:{}", json.toJSONString());
            }
        }
    }

    private Map<String, String> build(ThirdpartyAdvertClickHistoryEntity click) {
        Map<String, String> paramMap = Maps.newHashMap();

        if (StringUtils.isNotBlank(click.getImei())) {
            paramMap.put("muid", click.getImei());
        } else if (StringUtils.isNotBlank(click.getIdfa())) {
            paramMap.put("muid", click.getIdfa());
        }

        paramMap.put("os", restorOs(click));
        paramMap.put("imei", click.getImei());
        paramMap.put("idfa", click.getIdfa());
        paramMap.put("source", "hl");
        paramMap.put("conv_time", String.valueOf(System.currentTimeMillis()));

        return paramMap;
    }

    @Override
    public void nextDayLeft(ThirdpartyAdvertClickHistoryEntity click) {
        String callbackUrl = click.getCallBack();

        Map<String, String> paramMap = build(click);
        paramMap.put("event_type", "6");

        if (log.isDebugEnabled()) {
            log.debug("今日头条触发次日留存广告回调，回调参数：{}", JSON.toJSONString(paramMap));
        }

        String response = okHttpService.get(callbackUrl, paramMap, Maps.newHashMap());
        parseResponse(response);
    }

    private String restorOs(ThirdpartyAdvertClickHistoryEntity click) {
        if (String.valueOf(PlatformEnum.IOS.getCode()).equals(click.getOs())) {
            return "1";
        }
        return "0";
    }

    @Override
    public ThridpartyAdvertEnum platform() {
        return ThridpartyAdvertEnum.TT;
    }
}
