package com.bxm.foundation.config.advert.service.thirdparty.clickcallback;

import com.bxm.foundation.base.facade.bo.EquipmentBO;
import com.bxm.foundation.base.facade.service.EquipmentFacadeService;
import com.bxm.foundation.config.advert.entity.thirdparty.ThirdpartyAdvertClickHistoryEntity;
import com.bxm.foundation.config.advert.param.thirdparty.AdvertPublicParam;
import com.bxm.foundation.config.advert.param.thirdparty.KuaishouClickParam;
import com.bxm.foundation.config.advert.param.thirdparty.TtAdvertParam;
import com.bxm.foundation.config.advert.service.constant.ThirdpartyRedisConfig;
import com.bxm.foundation.config.advert.service.thirdparty.AdvertCallbackService;
import com.bxm.foundation.config.advert.service.enums.ThridpartyAdvertEnum;
import com.bxm.foundation.config.advert.service.thirdparty.facade.BaseServiceIntegration;
import com.bxm.foundation.config.advert.thirdparty.mapper.ThirdpartyAdvertClickHistoryMapper;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;


/**
 * @author lowi
 * @date 2021/6/16 9:22
 */
@Service
@Slf4j
@AllArgsConstructor
public class AdvertCallbackServiceImpl implements AdvertCallbackService {

    private final RedisSetAdapter redisSetAdapter;

    private final SequenceCreater sequenceCreater;

    private final AdvertHandlerProxy advertHandlerProxy;

    private final ThirdpartyAdvertClickHistoryMapper advertClickHistoryMapper;

    private final BaseServiceIntegration serviceIntegration;

    @Override
    public void addTtClick(TtAdvertParam param) {
        log.info("今日头条效果监控点击参数：[{}]", param);

        if (StringUtils.isBlank(param.getCallback_url())) {
            log.error("今日头条效果监控点击参数缺失，请求参数为：{}", param);
            return;
        }
        saveClickEvent(AdvertPublicParam.builder()
                .param(param)
                .thridpartyAdvertEnum(ThridpartyAdvertEnum.TT.name())
                .build());
    }

    @Override
    public void addKuaishouCallback(KuaishouClickParam param) {
        log.info("快手效果监控点击参数：[{}]", param);

        if (StringUtils.isBlank(param.getCallback())) {
            log.error("快手效果监控点击参数缺失，请求参数为：{}", param);
            return;
        }

        saveClickEvent(AdvertPublicParam.builder()
                .param(param)
                .thridpartyAdvertEnum(ThridpartyAdvertEnum.KUAISHOU_CLICK.name())
                .build());
    }

    /**
     * 保存点击事件记录
     *
     * @param param 点击参数
     */
    private Long saveClickEvent(AdvertPublicParam param) {
        log.info("广告点击记录：{}", JSON.toJSONString(param));

        //设备信息保存
        EquipmentBO equipmentParam = advertHandlerProxy.equipment(param);

        if (equipmentParam == null) {
            return null;
        }
        EquipmentFacadeService equipmentFacadeService = serviceIntegration.getEquipmentFacadeService();
        //获取设备id调用服务
        Long equipmentId = null;
        try {
            equipmentId = equipmentFacadeService.reportEquipment(equipmentParam);
        } catch (Exception e) {
            log.error("获取设备id调用服务失败，请求：{}", JSON.toJSONString(param), e);
            return null;
        }

        if (equipmentId == 0) {
            log.info("获取设备id调用服务失败，请求：{}", JSON.toJSONString(param));
            return null;
        }

        ThirdpartyAdvertClickHistoryEntity historyBean = advertHandlerProxy.history(param);

        //判断是否存在点击记录
        if (redisSetAdapter.exists(ThirdpartyRedisConfig.ADVERT_CLICK_CACHE, equipmentId)) {
            log.info("重复上报广告点击信息：{}", JSON.toJSONString(param));
        } else {
            redisSetAdapter.add(ThirdpartyRedisConfig.ADVERT_CLICK_CACHE, equipmentId);
        }

        historyBean.setId(sequenceCreater.nextLongId());
        historyBean.setEquipmentId(equipmentId);
        advertClickHistoryMapper.insert(historyBean);

        return equipmentId;
    }
}
