package com.bxm.foundation.config.advert.service.thirdparty.clickcallback;

import com.bxm.foundation.base.facade.bo.EquipmentBO;
import com.bxm.foundation.config.advert.entity.thirdparty.ThirdpartyAdvertClickHistoryEntity;

/**
 * @author lowi
 * @date 2021/6/16 10:31
 */

public interface AdvertHandler<T> {

    /**
     * 将广告参数转换为设备信息，用于创建唯一设备记录
     *
     * @param param 广告点击参数
     * @return 设备参数
     */
    EquipmentBO equipment(T param);

    /**
     * 将广告点击参数转换为点击历史模型进行存储
     *
     * @param param 点击参数
     * @return 保存的点击历史
     */
    ThirdpartyAdvertClickHistoryEntity history(T param);

    default String type() {
        return null;
    }
}
