package com.bxm.foundation.config.advert.service.thirdparty.clickcallback;

import com.bxm.foundation.base.facade.bo.EquipmentBO;
import com.bxm.foundation.config.advert.entity.thirdparty.ThirdpartyAdvertClickHistoryEntity;
import com.bxm.foundation.config.advert.param.thirdparty.AdvertPublicParam;
import com.bxm.newidea.component.JSON;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * @author lowi
 * @date 2021/6/16 10:30
 */
@Component
@Slf4j
public class AdvertHandlerProxy {

    private Map<String, AdvertHandler> handlerMap;


    @Autowired
    public AdvertHandlerProxy(List<AdvertHandler> handlerList) {
        handlerMap = Maps.newHashMap();

        if (!CollectionUtils.isEmpty(handlerList)) {
            handlerList.forEach(handler -> handlerMap.put(handler.type(), handler));
        }
    }

    EquipmentBO equipment(AdvertPublicParam param) {
        AdvertHandler advertHandler = handlerMap.get(param.getThridpartyAdvertEnum());
        if (advertHandler == null) {
            log.error("未配置第三方回调具体操作，默认不处理，param：{}", JSON.toJSONString(param));
            return null;
        }
        return advertHandler.equipment(param.getParam());
    }

    ThirdpartyAdvertClickHistoryEntity history(AdvertPublicParam param) {
        AdvertHandler advertHandler = handlerMap.get(param.getThridpartyAdvertEnum());
        if (advertHandler == null) {
            log.error("未配置第三方回调具体操作，默认不处理，param：{}", JSON.toJSONString(param));
            return null;
        }
        return advertHandler.history(param.getParam());
    }


}
