package com.bxm.foundation.config.advert.service.thirdparty.clickcallback.handler;

import com.bxm.foundation.base.facade.bo.EquipmentBO;
import com.bxm.foundation.config.advert.entity.thirdparty.ThirdpartyAdvertClickHistoryEntity;
import com.bxm.foundation.config.advert.param.thirdparty.KuaishouClickParam;
import com.bxm.foundation.config.advert.service.enums.ThridpartyAdvertEnum;
import com.bxm.foundation.config.advert.service.thirdparty.clickcallback.AdvertHandler;
import com.bxm.newidea.component.enums.PlatformEnum;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @author lowi
 * @date 2021/6/16 10:59
 */
@Slf4j
@Component
public class KuaishouClickHandler implements AdvertHandler<KuaishouClickParam> {

    @Override
    public EquipmentBO equipment(KuaishouClickParam param) {
        EquipmentBO equipmentParam = new EquipmentBO();
        equipmentParam.setAndroidIdMd5(param.getAndroidIdMd5());
        equipmentParam.setIdfaMd5(param.getIdfaMd5());
        equipmentParam.setImeiMd5(param.getImei());

        if (StringUtils.isNotBlank(param.getOaid())) {
            equipmentParam.setImei(param.getOaid());
        }

        equipmentParam.setPlatform(adapter(param));

        return equipmentParam;
    }

    private Integer adapter(KuaishouClickParam param) {
        if (StringUtils.isNotBlank(param.getIdfaMd5())) {
            return PlatformEnum.IOS.getCode();
        } else {
            return PlatformEnum.ANDROID.getCode();
        }
    }

    @Override
    public ThirdpartyAdvertClickHistoryEntity history(KuaishouClickParam param) {
        Date now = new Date();

        Date clickTime = now;
        if (null != param.getTs()) {
            clickTime = new Date(NumberUtils.parseToLong(param.getTs()));
        }

        ThirdpartyAdvertClickHistoryEntity clickHistoryBean = ThirdpartyAdvertClickHistoryEntity.builder()
                .imei(param.getImei())
                .androidId(param.getAndroidIdMd5())
                .idfa(param.getIdfaMd5())
                .callBack(param.getCallback())
                .createTime(now)
                .clickTime(clickTime)
                .type(ThridpartyAdvertEnum.KUAISHOU_CLICK.name())
                .os(adapter(param).toString())
                .build();

        if (StringUtils.isNotBlank(param.getOaid())) {
            clickHistoryBean.setImei(param.getOaid());
        }

        return clickHistoryBean;
    }

    @Override
    public String type() {
        return ThridpartyAdvertEnum.KUAISHOU_CLICK.name();
    }
}
