package com.bxm.foundation.config.advert.service.thirdparty.clickcallback.handler;

import com.bxm.foundation.base.facade.bo.EquipmentBO;
import com.bxm.foundation.config.advert.entity.thirdparty.ThirdpartyAdvertClickHistoryEntity;
import com.bxm.foundation.config.advert.param.thirdparty.TtAdvertParam;
import com.bxm.foundation.config.advert.service.thirdparty.clickcallback.AdvertHandler;
import com.bxm.foundation.config.advert.service.enums.ThridpartyAdvertEnum;
import com.bxm.newidea.component.enums.PlatformEnum;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @author lowi
 * @date 2021/6/16 10:45
 */
@Component
public class TtHandler implements AdvertHandler<TtAdvertParam> {

    @Override
    public EquipmentBO equipment(TtAdvertParam param) {
        EquipmentBO equipmentParam = new EquipmentBO();
        equipmentParam.setAndroidIdMd5(param.getAndroidid());
        equipmentParam.setImeiMd5(param.getImei());

        if (StringUtils.isNotBlank(param.getOaid())) {
            equipmentParam.setImeiMd5(param.getOaid());
        }

        equipmentParam.setIdfa(param.getIdfa());

        equipmentParam.setPlatform(adpterOS(param.getOs()));
        return equipmentParam;
    }

    private Integer adpterOS(String os) {
        if ("0".equals(os)) {
            return PlatformEnum.ANDROID.getCode();
        } else {
            return PlatformEnum.IOS.getCode();
        }
    }

    @Override
    public ThirdpartyAdvertClickHistoryEntity history(TtAdvertParam param) {
        ThirdpartyAdvertClickHistoryEntity clickHistoryBean = ThirdpartyAdvertClickHistoryEntity.builder()
                .imei(param.getImei())
                .androidId(param.getAndroidid())
                .idfa(param.getIdfa())
                .callBack(param.getCallback_url())
                .createTime(new Date())
                .clickTime(DateUtils.parseDateNonStrict(param.getTimestamp()))
                .unitId(param.getCid())
                .planId(param.getAdid())
                .type(ThridpartyAdvertEnum.TT.name())
                .os(adpterOS(param.getOs()).toString())
                .build();

        if (StringUtils.isNotBlank(param.getOaid())) {
            clickHistoryBean.setImei(param.getOaid());
        }

        return clickHistoryBean;
    }

    @Override
    public String type() {
        return ThridpartyAdvertEnum.TT.name();
    }
}
