package com.bxm.thirdparty.platform.model.dto;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

/**
 * @author lowi
 * @date 2023/3/14 15:21
 */
@Data
@Builder
public class PlatformResultDTO<T> {

    @Tolerate
    public PlatformResultDTO() {
    }

    /**
     * 返回请求是否成功
     */
    private Boolean success = Boolean.FALSE;

    /**
     * 如果失败，返回失败信息
     */
    private String errorMsg;

    /**
     * 返回体的信息
     */
    private T resultDTO;

    public static PlatformResultDTO fail(String errorMsg) {
        return PlatformResultDTO.builder()
                .success(false)
                .errorMsg(errorMsg)
                .build();
    }
}
