package com.bxm.thirdparty.platform.model.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import java.time.LocalDateTime;
import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 话费充值记录表
 * </p>
 *
 * @author liujia
 * @since 2023-04-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_charges_phone_log")
@ApiModel(value="ChargesPhoneLogEntity对象", description="话费充值记录表")
public class ChargesPhoneLogEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    private Long orderNo;

    private String outOrderNo;

    private String thirdPartyTrackNo;

    @ApiModelProperty(value = "充值的手机号")
    private String phone;

    private Date createTime;

    @ApiModelProperty(value = "支付金额")
    private BigDecimal payPrice;

    @ApiModelProperty(value = "真实消费金额")
    private BigDecimal sellMoney;

    private Date modifyTime;

    private Integer status;

    @ApiModelProperty(value = "是否为mock实现 0非mock 1 mock")
    private Integer mock;

    @ApiModelProperty(value = "充值平台")
    private String platform;

    @ApiModelProperty(value = "业务服务方名称")
    private String applicationName;

    private String requestId;

    private String errorMsg;


}
