package com.bxm.thirdparty.platform.model.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import java.time.LocalDateTime;
import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 电费充值记录表
 * </p>
 *
 * @author liujia
 * @since 2023-04-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_electric_log")
@ApiModel(value="ElectricLogEntity对象", description="电费充值记录表")
public class ElectricLogEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    private Long orderNo;

    private String outOrderNo;

    private String thirdPartyOrderNo;

    @ApiModelProperty(value = "省")
    private String province;

    @ApiModelProperty(value = "市")
    private String city;

    @ApiModelProperty(value = "充值的账户")
    private String account;

    private Date createTime;

    @ApiModelProperty(value = "支付金额")
    private BigDecimal amount;

    private Date modifyTime;

    private Integer status;

    @ApiModelProperty(value = "是否为mock实现 0非mock 1 mock")
    private Integer mock;

    @ApiModelProperty(value = "使用的充值平台")
    private String platform;

    @ApiModelProperty(value = "业务方名称")
    private String applicationName;

    @ApiModelProperty(value = "充值失败信息")
    private String errorMsg;

    private String requestId;
}
