package com.bxm.thirdparty.platform.model.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import java.time.LocalDateTime;
import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 支付订单记录
 * </p>
 *
 * @author liujia
 * @since 2023-04-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_payment_order_v2")
@ApiModel(value="PaymentOrderV2Entity对象", description="支付订单记录")
public class PaymentOrderV2Entity implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "所属业务应用")
    private String applicationName;

    @ApiModelProperty(value = "支付模式，H5、小程序、APP等")
    private String payMode;

    @ApiModelProperty(value = "支付平台")
    private String payPlatform;

    @ApiModelProperty(value = "订单标题")
    private String title;

    @ApiModelProperty(value = "订单描述")
    private String description;

    @ApiModelProperty(value = "支付订单编号")
    private Long orderNo;

    @ApiModelProperty(value = "业务服务支付订单编号")
    private String outOrderNo;

    @ApiModelProperty(value = "第三方支付订单编号")
    private String thirdPartyTradeNo;

    @ApiModelProperty(value = "支付金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "订单状态")
    private Integer status;

    private Integer mockOrder;

    @ApiModelProperty(value = "创建订单的请求来源IP")
    private String requestIp;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "收款账号ID")
    private String accountId;

    @ApiModelProperty(value = "完成支付的时间")
    private Date paymentTime;

    @ApiModelProperty(value = "变更时间")
    private Date modifyTime;

    @ApiModelProperty(value = "备注信息")
    private String remark;

    private String requestId;
}
