package com.bxm.thirdparty.platform.model.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import java.time.LocalDateTime;
import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 
 * </p>
 *
 * @author liujia
 * @since 2023-04-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_payment_refund_v2")
@ApiModel(value="PaymentRefundV2Entity对象", description="")
public class PaymentRefundV2Entity implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "支付平台")
    private String payPlatform;

    @ApiModelProperty(value = "退款对应的账号")
    private String accountId;

    @ApiModelProperty(value = "所属业务方")
    private String applicationName;

    @ApiModelProperty(value = "退款金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "退款状态（0：退款中，1：退款成功，2：退款失败）")
    private Integer status;

    @ApiModelProperty(value = "退款备注，当退款失败时记录失败原因")
    private String remark;

    @ApiModelProperty(value = "第三方订单编号")
    private String thirdPartyTradeNo;

    @ApiModelProperty(value = "支付订单编号(对应订单表中orderNo)")
    private Long paymentOrderNo;

    @ApiModelProperty(value = "退款订单编号")
    private Long refundOrderNo;

    @ApiModelProperty(value = "业务方传递的退款订单编号")
    private String outOrderNo;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "变更时间")
    private Date modifyTime;

    @ApiModelProperty(value = "退款通过时间")
    private Date refundTime;

    private String requestId;


}
