package com.bxm.thirdparty.platform.model.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import java.time.LocalDateTime;
import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 账号提前流水记录
 * </p>
 *
 * @author liujia
 * @since 2023-04-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_payment_withdraw_flow_v2")
@ApiModel(value="PaymentWithdrawFlowV2Entity对象", description="账号提前流水记录")
public class PaymentWithdrawFlowV2Entity implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "支付平台")
    private String payPlatform;

    @ApiModelProperty(value = "出款账号ID")
    private String accountId;

    @ApiModelProperty(value = "用户唯一标志，ALI平台 则为阿里账户 WX则为openId")
    private String identity;

    @ApiModelProperty(value = "ALI平台需要 用户姓名")
    private String userName;

    @ApiModelProperty(value = " wx提现需要提供appid")
    private String appId;

    @ApiModelProperty(value = "业务服务名")
    private String applicationName;

    @ApiModelProperty(value = "提现订单号")
    private Long withdrawOrderNo;

    @ApiModelProperty(value = "业务跟踪ID")
    private String outTrackNo;

    @ApiModelProperty(value = "第三方转账订单号")
    private String thirdPartyOrderNo;

    @ApiModelProperty(value = "订单状态")
    private Integer status;

    @ApiModelProperty(value = "订单金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "交易手续费")
    private BigDecimal fee;

    @ApiModelProperty(value = "原始响应的状态信息")
    private String errorMsg;

    @ApiModelProperty(value = "备注信息")
    private String remark;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "变更时间")
    private Date modifyTime;

    @ApiModelProperty(value = "提现完成时间")
    private Date withdrawTime;

    private String requestId;


}
