/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.electric;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.AbstractThirdPartyPlatformAction;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.adapter.electric.IElectricActionDispatcher;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PlatformBusinessTypeEnum;
import com.bxm.thirdparty.platform.facade.notify.ElectricNotifyResponse;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.facade.request.ElectricRequest;
import com.bxm.thirdparty.platform.facade.response.ElectricTopUpResponse;
import com.bxm.thirdparty.platform.model.entity.ElectricLogEntity;
import com.bxm.thirdparty.platform.service.ThirdPartyFailService;
import com.bxm.thirdparty.platform.service.impl.bo.ThirdPartyFailBO;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ElectricPlatformAction
extends AbstractThirdPartyPlatformAction<ElectricRequest, ElectricLogEntity> {
    private static final Logger log = LoggerFactory.getLogger(ElectricPlatformAction.class);
    @Resource
    private IElectricActionDispatcher<ElectricRequest, ElectricLogEntity> iElectrictActionDispatcher;
    @Resource
    private ThirdPartyFailService thirdPartyFailService;

    @Override
    public Message exec(PlatformContext<ElectricRequest, ElectricLogEntity> context) {
        Message exec = this.iElectrictActionDispatcher.exec(context);
        log.info("\u5145\u7535\u8d39\u52a8\u4f5c\u7ed3\u675f:{}", (Object)JSON.toJSONString((Object)exec.getParam(CommonConstant.RESULT_DTO)));
        if (!exec.isSuccess()) {
            this.thirdPartyFailService.submitThirdPartyFailLog(ThirdPartyFailBO.builder().param(JSON.toJSONString(context)).typeEnum(PlatformBusinessTypeEnum.ELECTRIC).errorMsg(exec.getLastMessage()).requestId(context.getRequestId()).build());
        }
        return exec;
    }

    @Override
    public Class<? extends BaseRequest> support() {
        return ElectricRequest.class;
    }

    @Override
    protected Message mockResult(PlatformContext<ElectricRequest, ElectricLogEntity> context) {
        ElectricRequest request = context.getRequest();
        ElectricLogEntity orderInfo = context.getOrderInfo();
        ElectricTopUpResponse response = new ElectricTopUpResponse();
        response.setSuccess(Boolean.valueOf(true));
        response.setRequestId(context.getRequestId());
        response.setAccount(request.getAccount());
        response.setAmount(request.getAmount());
        response.setOutOrderNo(orderInfo.getOutOrderNo());
        response.setOrderNo(orderInfo.getOrderNo());
        ElectricNotifyResponse notifyResponse = new ElectricNotifyResponse();
        notifyResponse.setSuccess(Boolean.valueOf(true));
        notifyResponse.setRequestId(context.getRequestId());
        notifyResponse.setOrderNo(orderInfo.getOrderNo());
        notifyResponse.setOutOrderNo(orderInfo.getOutOrderNo());
        this.submitQueueNotify(context, JSON.toJSONString((Object)notifyResponse));
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)response);
    }

    @Override
    protected Message asyncResult(PlatformContext<ElectricRequest, ElectricLogEntity> context) {
        ElectricRequest request = context.getRequest();
        ElectricLogEntity orderInfo = context.getOrderInfo();
        ElectricTopUpResponse response = new ElectricTopUpResponse();
        response.setSuccess(Boolean.valueOf(true));
        response.setRequestId(context.getRequestId());
        response.setAccount(request.getAccount());
        response.setAmount(request.getAmount());
        response.setOutOrderNo(orderInfo.getOutOrderNo());
        response.setOrderNo(orderInfo.getOrderNo());
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)response);
    }
}

