/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.electric.gongmao;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.notify.NotifyMessageSender;
import com.bxm.newidea.component.notify.channel.ChannelBuilder;
import com.bxm.newidea.component.notify.message.NotifyMessage;
import com.bxm.newidea.component.notify.message.NotifyMessageBuilder;
import com.bxm.newidea.component.notify.message.TextNotifyMessage;
import com.bxm.thirdparty.platform.adapter.chargephone.gongmao.bo.GongMaoBalanceBO;
import com.bxm.thirdparty.platform.adapter.chargephone.gongmao.bo.GongMaoOrderResultBO;
import com.bxm.thirdparty.platform.adapter.chargephone.gongmao.bo.GongMaoResultBO;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.adapter.electric.ElectricAction;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.request.ElectricRequest;
import com.bxm.thirdparty.platform.facade.response.ElectricTopUpResponse;
import com.bxm.thirdparty.platform.mapper.ElectricLogMapper;
import com.bxm.thirdparty.platform.model.entity.ElectricLogEntity;
import com.bxm.thirdparty.platform.utils.GongMaoUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GongMaoElectricAction
implements ElectricAction<ElectricRequest, ElectricLogEntity> {
    private static final Logger log = LoggerFactory.getLogger(GongMaoElectricAction.class);
    @Resource
    private NotifyMessageSender notifyMessageSender;
    @Resource
    private ThirdPartyConfigProperties thirdPartyConfigProperties;
    @Resource
    private ElectricLogMapper electricLogMapper;

    @Override
    public PlatformEnum support() {
        return PlatformEnum.GONG_MAO_ELECTRIC;
    }

    @Override
    public Message exec(PlatformContext<ElectricRequest, ElectricLogEntity> context) {
        String body;
        ElectricRequest request = context.getRequest();
        ElectricLogEntity orderInfo = context.getOrderInfo();
        Boolean southElectric = this.thirdPartyConfigProperties.getSouthElectric().contains(orderInfo.getProvince());
        String powerGrid = southElectric != false ? "\u5357\u65b9\u7535\u7f51" : "\u56fd\u5bb6\u7535\u7f51";
        if (orderInfo.getProvince().contains("\u5e7f\u897f")) {
            orderInfo.setProvince("\u5e7f\u897f\u58ee\u65cf");
            powerGrid = "\u5357\u65b9\u7535\u7f51";
        }
        BigDecimal amount = request.getAmount();
        String finalPowerGrid = powerGrid;
        Optional<ThirdPartyConfigProperties.GongMaoElectricDict> chargePhoneDictOptional = this.thirdPartyConfigProperties.getGongMaoElectricDictList().stream().filter(gongMaoChargePhoneDict -> gongMaoChargePhoneDict.getFaceValue().compareTo(amount) == 0 && gongMaoChargePhoneDict.getProductName().equals(finalPowerGrid)).findFirst();
        if (!chargePhoneDictOptional.isPresent()) {
            log.error("\u5de5\u732b\u7535\u8d39\u5145\u503c\u5931\u8d25\uff0c\u5339\u914d\u4e0d\u5230\u5de5\u732b\u4ea7\u54c1\u5b57\u5178\uff1a{}", context);
            return Message.build((boolean)false).setMessage("\u5de5\u732b\u7535\u8d39\u5145\u503c\u5931\u8d25\uff0c\u5339\u914d\u4e0d\u5230\u5de5\u732b\u4ea7\u54c1\u5b57\u5178");
        }
        ThirdPartyConfigProperties.GongMaoElectricDict gongMaoChargePhoneDict2 = chargePhoneDictOptional.get();
        GongMaoUtil gongMaoUtil = new GongMaoUtil(this.thirdPartyConfigProperties);
        GongMaoBalanceBO balance = gongMaoUtil.getBalance();
        if (balance == null) {
            log.error("\u5de5\u732b\u8bdd\u8d39\u5145\u503c\u5931\u8d25\uff0c\u83b7\u53d6\u8d26\u6237\u4f59\u989d\u5931\u8d25\uff1a{}", context);
            return Message.build((boolean)false).setMessage("\u83b7\u53d6\u5de5\u732b\u8d26\u6237\u4f59\u989d\u5931\u8d25");
        }
        this.remindAccountMoney(balance);
        if (balance.getAvailableAmount().compareTo(amount) < 0) {
            log.error("\u5de5\u732b\u8bdd\u8d39\u5145\u503c\u5931\u8d25\uff0c\u5145\u503c\u4f59\u989d\u4e0d\u8db3\uff1a{}", (Object)request);
            return Message.build((boolean)false).setMessage("\u5145\u503c\u4f59\u989d\u4e0d\u8db3");
        }
        String province = request.getProvince().replaceAll("\u7701", "");
        String city = request.getCity().replaceAll("\u5e02", "");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("requestId", orderInfo.getOrderNo());
        paramMap.put("productId", gongMaoChargePhoneDict2.getProductId());
        paramMap.put("faceValue", gongMaoChargePhoneDict2.getFaceValue());
        paramMap.put("account", request.getAccount());
        paramMap.put("province", province);
        paramMap.put("city", city);
        paramMap.put("orderCallbackUrl", this.thirdPartyConfigProperties.getServerUrl() + this.thirdPartyConfigProperties.getGongMaoElectricCallbackUrl());
        if (southElectric.booleanValue()) {
            paramMap.put("certType", request.getCertType());
            paramMap.put("certNo", request.getCertNo());
        }
        if (Objects.isNull(body = gongMaoUtil.submitOrder(paramMap))) {
            return Message.build((boolean)false).setBizCode("THIRD_PARTY_500").setMessage("\u8c03\u7528\u7b2c\u4e09\u65b9\u7535\u8d39\u5145\u503c\u5931\u8d25");
        }
        GongMaoResultBO gongMaoResultBO = (GongMaoResultBO)JSON.parseObject((String)body, GongMaoResultBO.class);
        if (Objects.isNull(gongMaoResultBO) || Objects.nonNull(gongMaoResultBO.getCode()) || !gongMaoResultBO.getSuccess().booleanValue()) {
            return Message.build((boolean)false).setMessage(body);
        }
        GongMaoOrderResultBO resultBO = (GongMaoOrderResultBO)JSON.parseObject((String)JSON.toJSONString((Object)gongMaoResultBO.getData()), GongMaoOrderResultBO.class);
        this.updateElectricLog(orderInfo.getId(), resultBO.getOrderNo());
        ElectricTopUpResponse response = new ElectricTopUpResponse();
        response.setRequestId(ThreadContext.getRequestId());
        response.setSuccess(Boolean.valueOf(true));
        response.setAccount(request.getAccount());
        response.setAmount(request.getAmount());
        response.setOrderNo(orderInfo.getOrderNo());
        response.setOutOrderNo(request.getOrderNo());
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)response);
    }

    private void updateElectricLog(Long id, String outOrderNo) {
        ElectricLogEntity electricLogEntity = new ElectricLogEntity();
        electricLogEntity.setId(id);
        electricLogEntity.setThirdPartyOrderNo(outOrderNo);
        this.electricLogMapper.updateById((Object)electricLogEntity);
    }

    private void remindAccountMoney(GongMaoBalanceBO balance) {
        if (Objects.nonNull(balance) && balance.getAvailableAmount().compareTo(this.thirdPartyConfigProperties.getAccountBalanceRemind()) <= 0) {
            this.notifyMessageSender.send((NotifyMessage)((TextNotifyMessage.TextNotifyMessageBuilder)((TextNotifyMessage.TextNotifyMessageBuilder)((TextNotifyMessage.TextNotifyMessageBuilder)NotifyMessageBuilder.textMessage().title("\u5de5\u732b\u5e73\u53f0\u4f59\u989d\u9884\u8b66")).content("\u5de5\u732b\u5e73\u53f0\u4f59\u989d\u9884\u8b66\uff1a\n\u5f53\u524d\u53ef\u7528\u91d1\u989d" + (balance.getAvailableAmount() == null ? BigDecimal.ZERO : balance.getAvailableAmount()) + "\n\u5f53\u524d\u603b\u91d1\u989d" + (balance.getTotalAmount() == null ? BigDecimal.ZERO : balance.getAvailableAmount()) + "\n\u5f53\u524d\u51bb\u7ed3\u91d1\u989d" + (balance.getFrozenAmount() == null ? BigDecimal.ZERO : balance.getAvailableAmount()) + "\n\u8bf7\u53ca\u65f6\u5145\u503c\uff01\uff01\uff01\uff01\uff01\nrequestId:" + ThreadContext.getRequestId() + "")).bindChannel(ChannelBuilder.dingding((String)this.thirdPartyConfigProperties.getDingdingUrl()))).build());
        }
    }
}

